/* =========================================================================
   CREA FILES (versione con ZIP unico)
   Dipendenze richieste in pagina: JSZip + FileSaver + jsPDF (+ autotable se usata)
   ========================================================================== */

var file_names = {};

/* =========================
   Utility comuni per lo ZIP
   ========================= */
function sanitizeName(s) {
  return (s || "").toString().trim().replace(/\s+/g, "_").replace(/[^\w.\-]/g, "");
}
async function addToZip(zipFolder, fileOrBlob, zipPath) {
  const ab = await fileOrBlob.arrayBuffer();
  zipFolder.file(zipPath, ab);
}
async function fetchBlob(url) {
  try {
    const res = await fetch(url, { credentials: "same-origin" });
    if (!res.ok) throw new Error("HTTP " + res.status);
    return await res.blob();
  } catch (e) {
    console.warn("Impossibile scaricare:", url, e);
    return null;
  }
}


/* =========================================
EXCEL: tutto inline in crea_files.js
- window.getExcelBlob(partita_iva, versione) -> Promise<Blob>
========================================= */
window.getExcelBlob = async function (partita_iva, versione) {
  // ===== Helper locali (isolati) =====
  const getTipoBeneficiarioSafe = () => {
    const fromGlobal = (typeof window.tipo_beneficiario !== "undefined" && window.tipo_beneficiario) ? ("" + window.tipo_beneficiario).toLowerCase() : "";
    return fromGlobal || ($("input[name='tipo_beneficiario']:checked").val() || "").toLowerCase();
  };
  const getTipoCantierabilitaSafe = () => {
    const fromGlobal = (typeof window.tipo_cantierabilita !== "undefined" && window.tipo_cantierabilita) ? ("" + window.tipo_cantierabilita).toLowerCase() : "";
    if (fromGlobal) return fromGlobal;
    const v = $("input[name='acquisizione-pareri']:checked").val();
    if (v === "necessita") return "necessita";
    if (v === "no-necessita") return "no-necessita";
    return "necessita-forse";
  };
  const tb = getTipoBeneficiarioSafe();
  const tc = getTipoCantierabilitaSafe();

  function raccogliAnagrafica(tb) {
    const d = {};
    if (tb === "associati") {
      d.denominazione = $("#denominazione_associati").val();
      d.sede_prov = $("#sede_provincia_associati").val();
      d.n_imprese = $("#numero_imprese_agricole_associate").val();
      d.codice_fiscale = $(`#codice_fiscale_${tb}`).val();
    } else if (tb === "singoli") {
      d.denominazione = $("#denominazione_singoli").val();
      d.ccia = $("#ccia-riferimento").val();
      d.rea = $("#numero-rea").val();
      d.inps = $("#numero-inps").val();
      d.codice_fiscale = $(`#codice_fiscale_${tb}`).val();
    } else if (tb === "comuni") {
      d.comune_riferimento = $("#comune_riferimento").val();
      d.cuua_comune = $("#cuua_comuni").val();
      d.codice_fiscale = $(`#codice_fiscale_${tb}`).val();  // <-- aggiunto qui ✅
      d.denominazione = $("#comune_riferimento").val(); // ✅ usa il Comune di riferimento come denominazione

    }
    d.nome = $(`#nome_${tb}`).val();
    d.cognome = $(`#cognome_${tb}`).val();
    d.data_nascita = getFormattedDate($(`#data-nascita_${tb}`).val());
    d.luogo_nascita = $(`#luogo-nascita_${tb}`).val();
    d.provincia_nascita = $(`#provincia-nascita_${tb}`).val();
    d.cuua = $(`#cuua_${tb}`).val();
    d.residenza = $(`#residenza_${tb}`).val();
    d.provincia = $(`#provincia_${tb}`).val();
    d.indirizzo = $(`#indirizzo_${tb}`).val();
    d.civico = $(`#civico_${tb}`).val();
    d.email = $(`#email_${tb}`).val();
    d.pec = $(`#pec_${tb}`).val();
    d.telefono = $(`#telefono_${tb}`).val();
    d.qualifica = $(`input[name=qualifica_${tb}]:checked`).val();
    d.sede_leg = $(`#sede_${tb}`).val();
    d.sede_indirizzo = $(`#sede_indirizzo_${tb}`).val();
    d.civico_sede = $(`#civico_sede_${tb}`).val();
    d.iban = $("#iban").val();  // è già uppercased da check_sezione_dati_bancari
    var codice_fiscale = $(`#codice_fiscale_${get_tipo_beneficiario()}`).val();

    const tot = parseInt($("#numero_localizzazioni_investimenti").val() || "1", 10);
    d.provincia_localizzazione = $("#provincia-localizzazione").val();
    d.comune_localizzazione = $("#comune-localizzazione").val();
    d.foglio = $("#foglio").val();
    d.particella = $("#particella").val();
    for (let i = 2; i <= tot; i++) {
      d[`provincia_localizzazione_${i}`] = $("#provincia-localizzazione").val();
      d[`comune_localizzazione_${i}`] = $("#comune-localizzazione_" + i).val();
      d[`foglio_${i}`] = $("#foglio_" + i).val();
      d[`particella_${i}`] = $("#particella_" + i).val();
    }
    return d;
  }

  function extract_data_by_key(rows, keys) {
    return keys.map(key => {
      return rows.map(riga => {
        const obj = riga[0];
        return obj?.[key] ?? '';
      });
    });
  }

  function setOtherData(sheet, sezione, columnHeader, rows, keys) {
    // opzionale: titolo sezione su 2 colonne (A:B)
    if (sezione !== '') {
      const rowIndex = sheet.rowCount + 1;
      sheet.mergeCells(`A${rowIndex}:B${rowIndex}`);
      const cell = sheet.getCell(rowIndex, 1);
      cell.value = sezione;
      cell.alignment = { horizontal: 'center', vertical: 'middle' };
      cell.font = { bold: true, size: 11 };
      cell.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
    }

    // prendiamo il primo “record” (nel tuo caso è [[oggetto]])
    const record = rows?.[0]?.[0] || {};

    // crea righe “Etichetta | Valore” usando il foglio corretto (sheet)
    columnHeader.forEach((label, i) => {
      const key = keys[i];
      const value = (record && Object.prototype.hasOwnProperty.call(record, key)) ? (record[key] ?? '') : '';

      const row = sheet.addRow([label, value]);
      row.getCell(1).font = { bold: true };
      row.eachCell((cell) => {
        cell.alignment = { wrapText: true, vertical: 'middle', horizontal: cell.col === 2 ? 'left' : 'left' };
        cell.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
      });
    });
  }

  function is_file($input) {
    const type = $input?.attr?.('type');
    return type === 'file';
  }

  // ===== Workbook =====
  const workbook = new ExcelJS.Workbook();
  const sheet1 = workbook.addWorksheet('1_Anagrafica');
  const sheet2 = workbook.addWorksheet('2_Checklist');
  const sheet3 = workbook.addWorksheet('3_Titoli_Abilitativi');

  // Logo (se disponibile)
  try {
    const src = $('#png_regione_siciliana').attr('src') || '';
    if (src.includes(',')) {
      const imageId = workbook.addImage({ base64: src.split(',')[1], extension: 'png' });
      [sheet1, sheet2, sheet3].forEach(sh => sh.addImage(imageId, { tl: { col: 0, row: 0 }, ext: { width: 60, height: 60 } }));
    }
  } catch (e) { /* opzionale */ }

  // ===== Sheet 1
  sheet1.mergeCells('A1:G4');
  sheet1.getCell('A1').value = 'Assessorato dell’agricoltura, dello sviluppo rurale e della pesca mediterranea\nDipartimento dell’agricoltura';
  sheet1.getCell('A1').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
  sheet1.getCell('A1').font = { bold: true, size: 14 };
  sheet1.getCell('A1').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFF' } };

  sheet1.mergeCells('A5:G12');
  sheet1.getCell('A5').value = 'Interventi in conto capitale per fronteggiare la crisi idrica in agricoltura in attuazione dell’art.13 della legge regionale 4 luglio 2024, n.23. Avviso approvato con D.D.G. n. 6186 del 29/08/2024';
  sheet1.getCell('A5').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
  sheet1.getCell('A5').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'D9D9D9' } };
  sheet1.getCell('A5').font = { size: 14 };

  sheet1.mergeCells('A13:G16');
  sheet1.getCell('A13').value = 'Verbale di ammissibilità';
  sheet1.getCell('A13').alignment = { horizontal: 'center', vertical: 'middle' };
  sheet1.getCell('A13').font = { bold: true, size: 14, color: { argb: 'FFFFFF' } };
  sheet1.getCell('A13').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: '002060' } };

  sheet1.columns = [
    { key: 'colA', width: 45.97 },
    { key: 'colB', width: 10.39 },
    { key: 'colC', width: 14.91 },
    { key: 'colD', width: 16.55 },
    { key: 'colE', width: 11.26 },
    { key: 'colF', width: 9.00 },
  ];

  // === ISPETTORATO + PROVINCIA (sotto le localizzazioni, nel foglio 1_Anagrafica) ===
  // === ISPETTORATO + PROVINCIA (stile "Dati Tecnico") ===
  (function () {
    const selIsp = $('#selezione_province_ispettorato option:selected');
    const ispTextFull = (selIsp.text() || '');               // es: "Palermo - mail@ispettorato..."
    const ispNome = (ispTextFull.split('-')[0] || '').trim(); // "Palermo"
    const ispMail = (ispTextFull.split('-')[1] || '').trim(); // "mail@..."

    // Titolo sezione
    const rowIndex = sheet1.rowCount + 1;
    sheet1.mergeCells(`A${rowIndex}:B${rowIndex}`);
    const titleCell = sheet1.getCell(rowIndex, 1);
    titleCell.value = 'Ispettorato Agricoltura';
    titleCell.alignment = { horizontal: 'center', vertical: 'middle' };
    titleCell.font = { bold: true, size: 11 };
    titleCell.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };

    // Riga helper (A=etichetta, B=valore)
    function addLine(label, value) {
      const r = sheet1.addRow([label, value]);
      r.getCell(1).font = { bold: true };
      r.eachCell((cell) => {
        cell.alignment = { vertical: 'middle', horizontal: 'left', wrapText: true };
        cell.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
      });
    }

    // Righe dati (come per il tecnico)
    addLine('Provincia Ispettorato', ispNome);
    addLine('Email Ispettorato', ispMail);

    sheet1.addRow([]); // separatore (facoltativo)
  })();
  const righe_anagrafica = [[raccogliAnagrafica(tb)]];
  let anagraficaHeader, anagrafica_keys;

  if (tb === "associati") {
    anagraficaHeader = ['Nome', 'Cognome', 'Data di nascita', 'Luogo di nascita', 'Provincia di nascita', 'Codice Fiscale', 'Residenza', 'Provincia', 'Indirizzo', 'Civico', 'Pec Istituzionale', 'Mail Istituzionale', 'Telefono/Cellulare', 'Qualifica', 'Denominazione', 'CUAA', 'Sede Legale', 'Provincia Sede Legale', 'Indirizzo Sede Legale', 'Civico Sede Legale', 'N. Imprese Agricole', 'IBAN'];
    anagrafica_keys = ["nome", "cognome", "data_nascita", "luogo_nascita", "provincia_nascita", "codice_fiscale", "residenza", "provincia", "indirizzo", "civico", "pec", "email", "telefono", "qualifica", "denominazione", "cuua", "sede_leg", "sede_prov", "sede_indirizzo", "civico_sede", "n_imprese", "iban"];
  } else if (tb === "singoli") {
    anagraficaHeader = ['Nome', 'Cognome', 'Data di nascita', 'Luogo di nascita', 'Provincia di nascita', 'CUAA', 'Residenza', 'Provincia', 'Indirizzo', 'Civico', 'Pec Aziendale', 'Mail Aziendale', 'Telefono/Cellulare', 'Qualifica', 'Denominazione', 'Sede Legale', 'Indirizzo Sede Legale', 'Civico Sede Legale', 'Provincia di riferimento della CCIAA', 'Numero REA', 'Numero iscrizione INPS', 'IBAN'];
    anagrafica_keys = ["nome", "cognome", "data_nascita", "luogo_nascita", "provincia_nascita", "cuua", "residenza", "provincia", "indirizzo", "civico", "pec", "email", "telefono", "qualifica", "denominazione", "sede_leg", "sede_indirizzo", "civico_sede", "ccia", "rea", "inps", "iban"];
  } else {
    // --- blocco ELSE (comuni)
    anagraficaHeader = [
      'Nome', 'Cognome', 'Data di nascita', 'Luogo di nascita', 'Provincia di nascita',
      'Codice Fiscale', 'Residenza', 'Provincia', 'Indirizzo', 'Civico',
      'Pec Istituzionale', 'Mail Istituzionale', 'Telefono/Cellulare', 'Qualifica',
      'Comune di Riferimento', 'Sede Legale', 'Indirizzo Sede Legale', 'Civico Sede Legale',
      'CUAA del Comune', 'IBAN'
    ];

    anagrafica_keys = [
      "nome", "cognome", "data_nascita", "luogo_nascita", "provincia_nascita",
      "codice_fiscale", "residenza", "provincia", "indirizzo", "civico", "pec", "email",
      "telefono", "qualifica", "comune_riferimento", "sede_leg", "sede_indirizzo",
      "civico_sede", "cuua", "iban" // qui puoi usare "cuua" (=> #cuua_comuni) o "cuua_comune"
    ];
  }
  setOtherData(sheet1, 'Sezione Anagrafica', anagraficaHeader, righe_anagrafica, anagrafica_keys);
  sheet1.addRow([]); sheet1.addRow([]);

  const localizzazioneHeader = ['Provincia di localizzazione', 'Comune di localizzazione', 'Foglio', 'Particelle'];
  let localizzazione_keys = ["provincia_localizzazione", "comune_localizzazione", "foglio", "particella"];
  setOtherData(sheet1, 'Localizzazione Investimento n.1', localizzazioneHeader, righe_anagrafica, localizzazione_keys);

  const totLoc = parseInt($("#numero_localizzazioni_investimenti").val() || "1", 10);
  for (let i = 2; i <= totLoc; i++) {
    localizzazione_keys = [`provincia_localizzazione_${i}`, `comune_localizzazione_${i}`, `foglio_${i}`, `particella_${i}`];
    setOtherData(sheet1, `Localizzazione Investimento n.${i}`, localizzazioneHeader, righe_anagrafica, localizzazione_keys);
  }
  sheet1.addRow([]);
  sheet1.addRow([]);
  // === DATI TECNICO (sotto le localizzazioni, sheet 1_Anagrafica) ===
  (function () {
    const nomeT = ($('#nome-tecnico').val() || '').trim();
    const cognomeT = ($('#cognome-tecnico').val() || '').trim();
    const emailT = ($('#mail-tecnico').val() || '').trim();
    const telT = ($('#recapito-tecnico').val() || '').trim();

    // Titolo sezione
    const rowIndex = sheet1.rowCount + 1;
    sheet1.mergeCells(`A${rowIndex}:B${rowIndex}`);
    const titleCell = sheet1.getCell(rowIndex, 1);
    titleCell.value = 'Dati Tecnico';
    titleCell.alignment = { horizontal: 'center', vertical: 'middle' };
    titleCell.font = { bold: true, size: 11 };
    titleCell.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };

    // Funzione per aggiungere una riga (etichetta in A, valore in B)
    function addLine(label, value) {
      const r = sheet1.addRow([label, value]); // A=etichetta, B=valore
      r.getCell(1).font = { bold: true }; // Etichetta in grassetto
      r.eachCell((cell) => {
        cell.alignment = { vertical: 'middle', horizontal: 'left', wrapText: true };
        cell.border = {
          top: { style: 'thin' },
          left: { style: 'thin' },
          bottom: { style: 'thin' },
          right: { style: 'thin' }
        };
      });
    }

    // Riga per ogni dato tecnico
    addLine('Nome tecnico', nomeT);
    addLine('Cognome tecnico', cognomeT);
    addLine('Email tecnico', emailT);
    addLine('Telefono tecnico', telT);

    sheet1.addRow([]); // Riga vuota separatrice (opzionale)
  })();
  // ===== Sheet 2 (Checklist spese) — con "Importo di contributo liquidabile/non liquidabile"
  sheet2.mergeCells('A1:K4');
  sheet2.getCell('A1').value =
    'Assessorato dell’agricoltura, dello sviluppo rurale e della pesca mediterranea\nDipartimento dell’agricoltura';
  sheet2.getCell('A1').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
  sheet2.getCell('A1').font = { bold: true, size: 14 };
  sheet2.getCell('A1').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFF' } };

  sheet2.mergeCells('A5:K8');
  sheet2.getCell('A5').value = 'VERBALE ISTRUTTORIA LIQUIDAZIONE';
  sheet2.getCell('A5').alignment = { horizontal: 'center', vertical: 'middle' };
  sheet2.getCell('A5').font = { bold: true, size: 14, color: { argb: 'FFFFFF' } };
  sheet2.getCell('A5').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: '002060' } };

  // Colonne (11 in totale)
  sheet2.columns = [
    { key: 'cat', width: 50 }, // 1  Categoria Interventi
    { key: 'n_fatt', width: 16 }, // 2  N. Fattura
    { key: 'emitt_fatt', width: 22 }, // 3  Emittente Fattura
    { key: 'desc', width: 28 }, // 4  Descrizione Fattura
    { key: 'imp', width: 18 }, // 5  Importo Imponibile €
    { key: 'imp_iva', width: 18 }, // 6  Importo Ivato €
    { key: 'contrib', width: 18 }, // 7  Contributo richiesto €
    { key: 'copia_fatt', width: 14 }, // 8  Copia Fattura (X)
    { key: 'liq', width: 18 }, // 9  Importo di contributo liquidabile €
    { key: 'non_liq', width: 20 }, // 10 Importo di contributo non liquidabile €
    { key: 'note', width: 14 }, // 11 Note
  ];

  // Formato numerico (5,6,7,9,10)
  [5, 6, 7, 9, 10].forEach(i => sheet2.getColumn(i).numFmt = '#,##0.00');

  // Header
  sheet2.addRow([
    "CATEGORIA INTERVENTI",
    "N. FATTURA",
    "EMITTENTE FATTURA",
    "DESCRIZIONE FATTURA",
    "IMPORTO IMPONIBILE €",
    "IMPORTO IVATO €",
    "CONTRIBUTO RICHIESTO €",
    "COPIA FATTURA",
    "IMPORTO CONTRIBUTO LIQUIDABILE €",
    "IMPORTO CONTRIBUTO NON LIQUIDABILE €",
    "NOTE"
  ]);
  {
    const hr = sheet2.getRow(sheet2.rowCount);
    hr.height = 42;
    hr.eachCell((c, col) => {
      c.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
      c.font = { bold: true };
      c.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
      c.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
      sheet2.getColumn(col).width = sheet2.columns[col - 1].width;
    });
    // Evidenzia la colonna 10: "IMPORTO DI CONTRIBUTO NON LIQUIDABILE €"
    hr.getCell(10).fill = {
      type: 'pattern',
      pattern: 'solid',
      fgColor: { argb: 'FFFF00' } // giallo
    };
    // >>> AGGIUNGI QUESTE 4 RIGHE PRIMA DEL COMMIT <<<
    hr.getCell(10).fill = {
      type: 'pattern',
      pattern: 'solid',
      fgColor: { argb: 'FFFF00' } // giallo
    };
    hr.commit();
  }

  // "X" se è presente la copia fattura
  function hasCopiaFatturaForRow($tr, idx) {
    const fileInp = $tr.find('input[type="file"][name="copia_fattura"]')[0];
    const hasLiveFile = !!(fileInp && fileInp.files && fileInp.files[0]);
    const hasSavedName = !!((window.file_names?.fattura || [])[idx]);
    return (hasLiveFile || hasSavedName) ? "X" : "";
  }

  function toNum(v) {
    let s = String(v ?? '').trim();
    if (s === '') return null;
  
    if (s.includes(',')) {
      // formato italiano "12.500,23" -> "12500.23"
      s = s.replace(/\./g, '').replace(',', '.');
    } else {
      // formato "12500.23": il punto è già il decimale, NON toccarlo
      // nessuna replace sui punti
    }
  
    const n = Number(s);
    return Number.isFinite(n) ? n : null;
  }

  const righe_tab = $("#investimenti tbody tr");
  const righe_spese = [];

  // accumulatori per totale (fallback + colonne nuove)
  let sumImp = 0, sumImpIva = 0, sumContrib = 0;
  let sumLiq = 0, sumNonLiq = 0;
  let foundTotaleRow = false;

  righe_tab.each(function (index) {
    const id = $(this).attr("id") || "";

    if (id.substring(0, 21) === "categoria_interventi_") {
      const $row = $(this);
      const categoria = $row.find("td:eq(0) select option:selected").text();
      const n_fattura = $row.find("td:eq(1) input").val();
      const emittente = $row.find("td:eq(2) input").val();
      const descrizione = $row.find("td:eq(3) input").val();
      const imp = toNum($row.find("td:eq(4) input").val());
      const imp_iva = toNum($row.find("td:eq(5) input").val());
      const contributo = toNum($row.find("td:eq(6) input").val());
      const copiaFattX = hasCopiaFatturaForRow($row, index);

      // Regola: con copia fattura tutto il contributo è liquidabile, altrimenti non liquidabile
      const importo_liquidabile = (copiaFattX === "X" && contributo != null) ? contributo : 0;
      const importo_non_liquidabile = (copiaFattX === "X" && contributo != null) ? 0 : (contributo ?? 0);

      // Accumula per i totali
      sumImp += imp ?? 0;
      sumImpIva += imp_iva ?? 0;
      sumContrib += contributo ?? 0;
      sumLiq += importo_liquidabile;
      sumNonLiq += importo_non_liquidabile;

      righe_spese.push({
        tab1: [
          categoria, n_fattura, emittente, descrizione,
          imp, imp_iva, contributo, copiaFattX,
          null, null,
          ""
        ]
      });
    }

    if (id === "totale_spdi") {
      foundTotaleRow = true;

      // se in pagina ci sono già i totali di imponibile/ivato/contributo, usali; altrimenti fallback agli accumulatori
      const impTotEl = $("#importo_imponibile_totale");
      const impIvaTotEl = $("#importo_imponibile_iva_totale");
      const contribTotEl = $("#contributo_richiesto_totale");

      const impTot = toNum(impTotEl.text?.().trim() || impTotEl.attr("valore")) ?? sumImp;
      const impIvaTot = toNum(impIvaTotEl.text?.().trim() || impIvaTotEl.attr("valore")) ?? sumImpIva;
      const contribTot = toNum(contribTotEl.text?.().trim() || contribTotEl.attr("valore")) ?? sumContrib;

      righe_spese.push({
        tab1: ["Totale", "", "", "", impTot, impIvaTot, contribTot, "", sumLiq, sumNonLiq, ""]
      });
    }
  });

  // Se la riga "totale_spdi" non è presente nel DOM, aggiungi una riga Totale con i contatori
  if (!foundTotaleRow) {
    righe_spese.push({
      tab1: ["Totale", "", "", "", sumImp, sumImpIva, sumContrib, "", sumLiq, sumNonLiq, ""]
    });
  }

  // Scrittura righe (allinea a destra le colonne numeriche 5,6,7,9,10)
  righe_spese.map(r => r.tab1).forEach(el => {
    const row = sheet2.addRow(el);
    row.height = 40;
    row.eachCell((c, i /* 1-based */) => {
      c.alignment = {
        horizontal: ([5, 6, 7, 9, 10].includes(i)) ? 'right' : 'center',
        vertical: 'middle',
        wrapText: true
      };
    });
    if (el[0] === "Totale") {
      row.getCell(1).font = { bold: true };
      // opzionale: enfatizza i totali anche sulle colonne numeriche
      [5, 6, 7, 9, 10].forEach(i => row.getCell(i).font = { bold: true });
    }
  });

  // Bordi
  sheet2.eachRow(row => row.eachCell(cell => {
    cell.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
  }));
  // === BLOCCO DRS + COLONNA "VALIDAZIONE" (foglio 2, sotto la tabella) ===
  // === BLOCCO DRS + COLONNA "VALIDAZIONE" (foglio 2, sotto la tabella) ===
  (function addDrsBlock() {
    // spazio dopo la tabella
    sheet2.addRow([]);
    sheet2.addRow([]);

    // ----- INPUT DAL DOM -----
    const nDRS = ($("#numeroDRS").val() || "").trim();
    const dDRS = ($("#dataDRS").val() || "").trim(); // atteso "YYYY-MM-DD"
    const impDRS = ($("#importoAmmissibile").val() || "").trim();

    function toNum(v) {
      let s = String(v ?? '').trim();
      if (s === '') return null;
    
      if (s.includes(',')) {
        // formato italiano "12.500,23" -> "12500.23"
        s = s.replace(/\./g, '').replace(',', '.');
      } else {
        // formato "12500.23": il punto è già il decimale, NON toccarlo
        // nessuna replace sui punti
      }
    
      const n = Number(s);
      return Number.isFinite(n) ? n : null;
    }
    const dataIT = (iso) => {
      if (!iso) return "";
      const [y, m, d] = iso.split("-");
      return `${d}/${m}/${y}`;
    };

    // ----- TITOLO SEZIONE -----
    const titleRow = sheet2.addRow(['DATI RELATIVI AL DRS (PROVVEDIMENTO DI CONCESSIONE)']);
    sheet2.mergeCells(`A${titleRow.number}:C${titleRow.number}`);
    titleRow.getCell(1).font = { bold: true, size: 12 };
    titleRow.getCell(1).alignment = { horizontal: 'center', vertical: 'middle' };
    titleRow.getCell(1).fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'E9EEF7' } };
    titleRow.eachCell(c => c.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } });

    // intestazione "VALIDAZIONE"
    const headerRow = sheet2.addRow(['', '', 'VALIDAZIONE']);
    headerRow.getCell(3).alignment = { horizontal: 'center', vertical: 'middle' };
    headerRow.getCell(3).font = { bold: true };
    headerRow.eachCell(c => {
      c.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
    });

    // === ETICHETTE (ordine come nello screenshot) ===
    const labels = [
      'CONTRIBUTO CONCESSO CON DRS',
      'NUMERO DRS',
      'DATA DRS',
      'CUP',
      'DATA DICHIARAZIONE ISCRIZIONE CAMERA DI COMMERCIO',
      'PROTOCOLLO RICHIESTO ANTIMAFIA',
      'DATA PROTOCOLLO DDG',
      'NUMERO PROTOCOLLO DDG',
      'DIRIGENTE (nome e cognome)',
      'NUMERO SERVIZIO',
      'DATA NOTA PAGAMENTO CONDIZIONE RISOLUTIVA',
      'PROTOCOLLO NOTA PAGAMENTO CONDIZIONE RISOLUTIVA',
      'DATA RICHIESTA LIQUIDAZIONE',
      'PROTOCOLLO RICHIESTA',
      'DATA REDAZIONE ISTRUTTORIA',
      'ISTRUTTORE'
    ];

    // === VALORI (puoi poi collegarli ai tuoi campi DOM) ===
    const values = [
      toNum(impDRS),
      nDRS,
      dataIT(dDRS),
      '', '', '', '', '', '', '',
      '', '', '', '', '', ''
    ];

    // === TUTTO IL BLOCCO IN GIALLO ===
    const giallo = 'FFF59D'; // giallo tenue (excel argb)

    labels.forEach((label, i) => {
      const row = sheet2.addRow([label, values[i] ?? '', '']);

      const a = row.getCell(1);
      a.font = { bold: true };
      a.alignment = { horizontal: 'left', vertical: 'middle', wrapText: true };
      a.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: giallo } };

      const b = row.getCell(2);
      b.alignment = { horizontal: 'right', vertical: 'middle' };
      if (typeof values[i] === 'number') b.numFmt = '#,##0.00';

      const c = row.getCell(3);
      c.alignment = { horizontal: 'center', vertical: 'middle' };

      [a, b, c].forEach(cell => {
        cell.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
      });
    });
  })();

  // ===== Sheet 3 (Titoli abilitativi)
  sheet3.mergeCells('A1:G4');
  sheet3.getCell('A1').value = 'Assessorato dell’agricoltura, dello sviluppo rurale e della pesca mediterranea\nDipartimento dell’agricoltura';
  sheet3.getCell('A1').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
  sheet3.getCell('A1').font = { bold: true, size: 14 };
  sheet3.getCell('A1').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFF' } };

  sheet3.mergeCells('A5:G8');
  sheet3.getCell('A5').value = 'VERBALE ISTRUTTORIA LIQUIDAZIONE';
  sheet3.getCell('A5').alignment = { horizontal: 'center', vertical: 'middle' };
  sheet3.getCell('A5').font = { bold: true, size: 14, color: { argb: 'FFFFFF' } };
  sheet3.getCell('A5').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: '002060' } };

  sheet3.mergeCells('A9:G13');
  sheet3.getCell('A9').value = $('input[name="acquisizione-pareri"]:checked').closest('.form-check').find('label').text().trim();
  sheet3.getCell('A9').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
  sheet3.getCell('A9').font = { bold: true, size: 14 };
  sheet3.getCell('A9').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'fcfc6a' } };

  // === Imposta le colonne e l'header dinamico
  if (tc === "necessita") {
    sheet3.columns = [
      { key: 'tit_ab', width: 50 },
      { key: 'doc', width: 30 },
      { key: 'note', width: 15 }
    ];
    sheet3.addRow(["TITOLO ABILITATIVO", "DOCUMENTO", "NOTE"]);

  } else if (tc === "necessita-forse") {
    sheet3.columns = [
      { key: 'tit_ab', width: 30 },
      { key: 'richiesto', width: 15 },
      { key: 'rilasciato', width: 15 },
      { key: 'doc_rich', width: 30 },
      { key: 'doc_ril', width: 30 },
      { key: 'note', width: 15 }
    ];
    sheet3.addRow([
      "TITOLO ABILITATIVO", "RICHIESTO", "RILASCIATO",
      "DOCUMENTO RICHIESTO", "DOCUMENTO RILASCIATO", "NOTE"
    ]);

  } else {
    sheet3.columns = [
      { key: 'tit_ab', width: 50 },
      { key: 'doc', width: 30 },
      { key: 'note', width: 15 }
    ];
    sheet3.addRow(["TITOLO ABILITATIVO", "DOCUMENTO", "NOTE"]);
  }

  // === Stile header
  {
    const hr3 = sheet3.getRow(sheet3.rowCount);
    hr3.height = 42;
    hr3.eachCell((c, col) => {
      c.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
      c.font = { bold: true };
      c.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
      c.border = {
        top: { style: 'thin' },
        left: { style: 'thin' },
        bottom: { style: 'thin' },
        right: { style: 'thin' }
      };
      sheet3.getColumn(col).width = sheet3.columns[col - 1].width;
    });
    hr3.commit();
  }

  // === Popola le righe dinamicamente
  const righe_cant = [];

  if (tc === "necessita") {
    // Ogni riga dei titoli abilitativi deve avere una classe/containment, es. .ep-row
    // (è la stessa che usi più sotto per lo ZIP: input.closest(".ep-row"))
    const rows = $(".ep-row");   // <--- assicurati che la riga abbia questa classe

    rows.each(function (i) {
      const $row = $(this);
      const nome = ($row.find('input[id^="enti_preposti_input"]').val() || "").trim();

      // prendi il file della STESSA riga, non via id "costruito"
      const fileInput = $row.find('input[type="file"][name="enti_preposti_file"]')[0];

      let doc = "";
      if (fileInput?.files?.length > 0) {
        doc = fileInput.files[0].name;
      } else if (window.file_names?.enti_preposti_file?.[i]) {
        // nome salvato lato server (se presente)
        doc = window.file_names.enti_preposti_file[i];
      } // altrimenti resta stringa vuota: NON duplicare il titolo

      // Inserisci riga solo se c'è almeno il titolo o il documento
      if (nome || doc) {
        righe_cant.push({ tab1: [nome, doc, ""] });
      }
    });
  } else if (tc === "necessita-forse") {
    // Caso 2 → tabella complessa
    const rt = $(".tabella-testi tbody tr");
    let i1 = 0, i2 = 0;

    rt.each(function () {
      const id = $(this).attr("id") || "";
      if (!id.startsWith("titoli_")) return;

      const titolo = $(this).find("td:eq(0) input").val();
      const richiesto = $(this).find("td:eq(1) select option:selected").text();
      const rilasciato = $(this).find("td:eq(2) select option:selected").text();

      // File richiesto
      const in1 = $(this).find("td:eq(3) input");
      let doc_rich = "";
      if (in1[0]?.files?.length > 0) {
        doc_rich = in1[0].files[0].name;
      } else if (window.file_names?.documento_abilitativo_richiesto?.[i1]) {
        doc_rich = window.file_names.documento_abilitativo_richiesto[i1];
      } else {
        doc_rich = in1.val() || "";
      }
      if (in1[0]?.files?.length > 0) i1++;

      // File rilasciato
      const in2 = $(this).find("td:eq(4) input");
      let doc_ril = "";
      if (in2[0]?.files?.length > 0) {
        doc_ril = in2[0].files[0].name;
      } else if (window.file_names?.documento_abilitativo_rilasciato?.[i2]) {
        doc_ril = window.file_names.documento_abilitativo_rilasciato[i2];
      } else {
        doc_ril = in2.val() || "";
      }
      if (in2[0]?.files?.length > 0) i2++;

      // Inserisci la riga anche se manca uno dei due documenti
      if (titolo || richiesto || rilasciato || doc_rich || doc_ril) {
        righe_cant.push({ tab1: [titolo, richiesto, rilasciato, doc_rich, doc_ril, ""] });
      }
    });
  }

  // === Scrivi le righe nel foglio
  righe_cant.map(r => r.tab1).forEach(el => {
    const row = sheet3.addRow(el);
    row.height = 52;
    row.eachCell(c => {
      c.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
      c.border = {
        top: { style: 'thin' },
        left: { style: 'thin' },
        bottom: { style: 'thin' },
        right: { style: 'thin' }
      };
    });
  });


  // === SEZIONE: DOCUMENTAZIONE ALLEGATA (presa da window.allegatiSelezionati)
  (function addAllegatiToSheet3() {
    // Assicurati che esista l'array popolato prima della chiamata a getExcelBlob
    const allegati = Array.isArray(window.allegatiSelezionati) ? window.allegatiSelezionati : [];

    // Riga vuota di separazione
    sheet3.addRow([]);

    // Calcola l'ultima colonna dello sheet3 per il merge del titolo sezione
    const lastCol = sheet3.columnCount || (sheet3.columns ? sheet3.columns.length : 3);
    const titleRowIndex = sheet3.rowCount + 1;

    // Titolo sezione
    sheet3.mergeCells(titleRowIndex, 1, titleRowIndex, lastCol);
    const titleCell = sheet3.getCell(titleRowIndex, 1);
    titleCell.value = 'DOCUMENTAZIONE ALLEGATA';
    titleCell.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    titleCell.font = { bold: true, size: 12 };
    titleCell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'fcfc6a' } };
    titleCell.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };

    // Header della tabella allegati
    const headerRow = sheet3.addRow(["Documento", "Nome file", "Presenza", "Convalida"]); headerRow.height = 42;
    headerRow.eachCell((c, col) => {
      c.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
      c.font = { bold: true };
      c.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
      c.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
      // opzionale: larghezze base
      if (col === 1) sheet3.getColumn(col).width = Math.max(sheet3.getColumn(col).width || 30, 40);
      if (col === 2) sheet3.getColumn(col).width = Math.max(sheet3.getColumn(col).width || 30, 40);
      if (col === 3) sheet3.getColumn(col).width = Math.max(sheet3.getColumn(col).width || 15, 18);
      if (col === 4) sheet3.getColumn(col).width = Math.max(sheet3.getColumn(col).width || 15, 18); // <-- NEW

    });
    headerRow.commit?.();

    // Righe contenuto
    if (allegati.length === 0) {
      const r = sheet3.addRow(["(nessun allegato selezionato)", "", "No", ""]);
      r.height = 28;
      r.eachCell(c => {
        c.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
        c.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
      });
    } else {
      allegati.forEach(a => {
        const r = sheet3.addRow([
          a.label || "",
          a.nomeFile || "",
          (a.nomeFile && a.nomeFile.trim() ? "Sì" : "No"),
          "" // <-- nuova colonna “Convalida”
        ]);
        r.height = 28;
        r.getCell(2).alignment = { horizontal: 'left', vertical: 'middle', wrapText: true };
        r.eachCell((c, i) => {
          if (i !== 2) c.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
          c.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
        });
      });
    }
  })();
  // ===== Sheet 4 (INPUT_RPA) — valori tramite formule robuste =====
  const sheet4 = workbook.addWorksheet('4_INPUT_RPA');

  // Alias ai fogli (nomi con apice per sicurezza)
  const S1 = "'1_Anagrafica'";
  const S2 = "'2_Checklist'";

  // Helpers: prendi il valore in colonna B cercando l'etichetta esatta in colonna A
  const fByLabelS1 = (label) => `IFERROR(INDEX(${S1}!B:B, MATCH("${label}", ${S1}!A:A, 0)), "")`;
  const fByLabelS2 = (label) => `IFERROR(INDEX(${S2}!B:B, MATCH("${label}", ${S2}!A:A, 0)), "")`;

  // Totali: riga dove A="Totale" + colonna desiderata (F=Ivato, G=Contributo richiesto, I=Contributo liquidabile)
  const fTotCol = (colLetter) => `IFERROR(INDEX(${S2}!${colLetter}:${colLetter}, MATCH("Totale", ${S2}!A:A, 0)), "")`;

  // Header nell'ordine richiesto
  const header4 = [
    'NOME E COGNOME FUNZIONARIO ISTRUTTORIA',
    'DATA REDAZIONE ISTRUTTORIA',
    'NUMERO SERVIZIO',
    'IPA',
    'DATA DDG',
    'NUMERO PROTOCOLLO DDG',
    'DIRIGENTE',
    'CUP',
    'DENOMINAZIONE',
    'CUAA',
    'NUMERO DRS',
    'DATA DRS',
    'IMPORTO AMMISSIBILE',
    'ECONOMIA',
    'DATA RICHIESTA LIQUIDAZIONE',
    'PROTOCOLLO RICHIESTA LIQUIDAZIONE',
    'IMPORTO CONTRIBUTO RICHIESTO',
    'SPESA RENDICONTATA (IVATA)',
    'IMPORTO CONTRIBUTO LIQUIDABILE',
    'DATA ISCRIZIONE CAMERA DI COMMERCIO',
    'PROTOCOLLO RICHIESTA ANTIMAFIA',
    'PROTOCOLLO NOTA PAGAMENTO OCR',
    'DATA PROTOCOLLO NOTA PAGAMENTO OCR',
    'IBAN'
  ];

  // Colonne + stile header
  sheet4.columns = header4.map((h, i) => ({ header: h, key: `c${i + 1}`, width: 30 }));
  {
    const hr = sheet4.getRow(1);
    hr.height = 28;
    hr.eachCell(c => {
      c.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
      c.font = { bold: true };
      c.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
      c.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
    });
    hr.commit?.();
  }

  // Riga valori (solo formule)
  const r4 = sheet4.addRow(new Array(header4.length).fill(''));

  // Formule per ogni colonna (se l'etichetta non esiste -> stringa vuota)
  [
    { i: 1, f: fByLabelS2('ISTRUTTORE') },
    { i: 2, f: fByLabelS2('DATA REDAZIONE ISTRUTTORIA') },
    { i: 3, f: fByLabelS2('NUMERO SERVIZIO') },                  // se non presente resta vuoto
    { i: 4, f: fByLabelS1('Provincia Ispettorato') },            // IPA = Provincia Ispettorato (foglio 1)                          // se non presente resta vuoto
    { i: 5, f: fByLabelS2('DATA PROTOCOLLO DDG') },              // "DATA DDG"
    { i: 6, f: fByLabelS2('NUMERO PROTOCOLLO DDG') },
    { i: 7, f: fByLabelS2('DIRIGENTE (nome e cognome)') },
    { i: 8, f: fByLabelS2('CUP') },
    // DENOMINAZIONE = Denominazione (singoli/associati) oppure Comune di Riferimento (comuni)
    { i:  9, f: `IF(${fByLabelS1('Denominazione')}<>"", ${fByLabelS1('Denominazione')},
                  IF(${fByLabelS1('Comune di Riferimento')}<>"", ${fByLabelS1('Comune di Riferimento')}, ""))` },
    // CUAA = CUAA (singoli/associati) oppure CUAA del Comune (comuni)
    { i: 10, f: `IF(${fByLabelS1('CUAA')}<>"", ${fByLabelS1('CUAA')},
                  IF(${fByLabelS1('CUAA del Comune')}<>"", ${fByLabelS1('CUAA del Comune')}, ""))` },
    { i: 11, f: fByLabelS2('NUMERO DRS') },
    { i: 12, f: fByLabelS2('DATA DRS') },
    { i: 13, f: fByLabelS2('CONTRIBUTO CONCESSO CON DRS') },      // Importo ammissibile
    { i: 14, f: `IFERROR(M${r4.number}-S${r4.number},"")` },                // opzionale
    { i: 15, f: fByLabelS2('DATA RICHIESTA LIQUIDAZIONE') },
    { i: 16, f: fByLabelS2('PROTOCOLLO RICHIESTA') },             // richiesta liquidazione
    { i: 17, f: fTotCol('G') },                                   // Contributo richiesto (tot colonna G)
    { i: 18, f: fTotCol('F') },                                   // Spesa rendicontata ivata (tot colonna F)
    { i: 19, f: fTotCol('I') },                                   // Importo contributo liquidabile (tot colonna I)
    { i: 20, f: fByLabelS2('DATA DICHIARAZIONE ISCRIZIONE CAMERA DI COMMERCIO') },
    { i: 21, f: fByLabelS2('PROTOCOLLO RICHIESTO ANTIMAFIA') },
    { i: 22, f: fByLabelS2('PROTOCOLLO NOTA PAGAMENTO CONDIZIONE RISOLUTIVA') }, // OCR
    { i: 23, f: fByLabelS2('DATA NOTA PAGAMENTO CONDIZIONE RISOLUTIVA') },       // Data OCR
    { i: 24, f: fByLabelS1('IBAN') },
  ].forEach(({ i, f }) => { r4.getCell(i).value = { formula: f }; });

  // Formati numerici/align
  [13, 14, 17, 18, 19].forEach(i => {
    r4.getCell(i).numFmt = '#,##0.00';
    r4.getCell(i).alignment = { horizontal: 'right', vertical: 'middle' };
  });
  r4.eachCell((c, idx) => {
    if (![13, 14, 17, 18, 19].includes(idx)) {
      c.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    }
    c.border = { top: { style: 'thin' }, left: { style: 'thin' }, bottom: { style: 'thin' }, right: { style: 'thin' } };
  });


  // === Chiusura getExcelBlob: crea il Blob .xlsx e restituiscilo
  const buffer = await workbook.xlsx.writeBuffer();
  return new Blob([buffer], {
    type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
  });
}; // <--- chiude window.getExcelBlob
/* =========================================
   CLICK principale: valida + costruisci ZIP
   ========================================= */
$(document).on("click", ".crea-files", async function () {
  // ===== VALIDAZIONI =====

  // 🔴 Conta anche gli alert come errori della sezione
  var errori_totali = 0;
  var errori_ispettorato = check_provincia_ispettorato();
  var errori_sezione_anagrafica = check_sezione_anagrafica();
  var errori_sezione_localizzazione_investimento = check_sezione_localizzazione_investimento();
  var errori_sezione_liquidazione_spese = check_sezione_liquidazione_spese();
  var errori_sezione_cantierabilita = check_sezione_cantierabilita();
  var errori_sezione_privacy = check_sezione_privacy();
  var errori_firma = check_errori_firma();
  var errori_documentazione = validaSezioneDocumentazione();
  var errori_sezione_dati_bancari = check_sezione_dati_bancari();
  var errori_sezione_tecnico = check_sezione_tecnico();
  var errori_atto_costitutivo = check_atto_costitutivo_associati();


  errori_totali = errori_ispettorato * 1 + errori_sezione_anagrafica * 1 + errori_sezione_localizzazione_investimento * 1 +
    errori_sezione_liquidazione_spese * 1 + errori_sezione_cantierabilita * 1 +
    errori_sezione_privacy * 1 + errori_firma * 1 + errori_documentazione * 1
    + errori_sezione_dati_bancari * 1 + errori_sezione_tecnico * 1 + errori_atto_costitutivo * 1;   // <--- AGGIUNTO;

  if (errori_totali !== 0) {
    $('html, body').animate({
      scrollTop: $('.background-color-error-accordion:visible:first').offset().top - 125
    }, 500);
    return;
  }



  // ===== DATI BASE =====
  const tipo = get_tipo_beneficiario();
  const partita_iva = $(`#cuua_${tipo}`).val();
  const versioneRaw = $("#versione").val() || "1_0";
  const versione = versioneRaw.replace(".", "_");
  const tipoBeneficiario = $("input[name='tipo_beneficiario']:checked").val() || "";
  const acquisizionePareriValue = $("input[name='acquisizione-pareri']:checked").val();

  // ===== PREPARA ZIP =====
  const zip = new JSZip();
  const root = zip.folder(`${sanitizeName(partita_iva)}_${versione}`);
  const foldAllegati = root.folder("Allegati");
  const foldSpese = root.folder("Liquidazione_Spese");
  const foldTitoli = root.folder("Titoli_Abilitativi");

  // <<< AGGIUNGI: azzera la lista degli allegati che stamperai nel PDF
  window.allegatiSelezionati = [];
  // ===== PDF PRINCIPALE =====


  // ===== ALLEGATI SALDO (obbligatori e facoltativi) =====
  const allegatiSaldo = [
    { id: "doc_identita", filename: "Documento_identita", required: true },
    { id: "delibera_associazione", filename: "Delibera_associazione", required: false },
    { id: "relazione_tecnica", filename: "Relazione_tecnica", required: true },
    { id: "computo_consuntivo", filename: "Computo_metrico_consuntivo", required: true },
    { id: "elaborati_tecnici", filename: "Elaborati_tecnici", required: false },
    { id: "elenco_fatture", filename: "Elenco_fatture", required: true },
    { id: "registro_iva", filename: "Registro_IVA", required: false },
    { id: "fatture_elettroniche", filename: "Fatture_elettroniche", required: true },
    { id: "bonifici", filename: "Bonifici_o_ricevute", required: true },
    { id: "estratti_conto", filename: "Estratti_conto_corrente", required: true },
    { id: "quietanza_fornitori", filename: "Quietanza_fornitori", required: true },
    { id: "dichiarazione_tecnico", filename: "Dichiarazione_tecnico", required: true },
    { id: "foto_investimenti", filename: "Fotografie_investimenti", required: true },
    { id: "certificazione_conformita", filename: "Certificazione_conformita", required: false },
    { id: "dichiarazione_impegno", filename: "Dichiarazione_impegno_beneficiario", required: true }
  ];

  for (const item of allegatiSaldo) {
    if (item.id === "registro_iva" && tipoBeneficiario === "comuni") continue;
    const input = document.getElementById(item.id);
    if (!input) continue;
    const f = input.files?.[0];
    if (!f) continue; // i mancanti obbligatori sono già intercettati dalla validazione
    const est = (f.name.split('.').pop() || "").toLowerCase();
    const nome = `${sanitizeName(partita_iva)}_${item.filename}_${versione}.${sanitizeName(est)}`;
    await addToZip(foldAllegati, f, nome);

    // <<< AGGIUNGI: memorizza per stampa PDF
    window.allegatiSelezionati.push({
      label: item.filename.replaceAll("_", " "),
      nomeFile: nome
    });
  }

  // ===== ALLEGATI FACOLTATIVI EXTRA DINAMICI =====
  const extraInputs = document.querySelectorAll("#upload_extra_container input[type='file']");
  let extraIdx = 1;
  for (const inp of extraInputs) {
    const f = inp.files?.[0];
    if (!f) continue;
    const est = (f.name.split('.').pop() || "").toLowerCase();
    const nome = `${sanitizeName(partita_iva)}_Documento_facoltativo_${extraIdx}_${versione}.${sanitizeName(est)}`;
    await addToZip(foldAllegati, f, nome);
    window.allegatiSelezionati.push({
      label: `Documento facoltativo ${extraIdx}`,
      nomeFile: nome
    });
    extraIdx++;
  }

  // ===== DELEGA (Comuni → Delegato) =====
  const qualificaComuni = $("input[name='qualifica_comuni']:checked").val();
  const file_delega = document.getElementById("upload_delega")?.files?.[0];
  if (qualificaComuni === "Delegato" && file_delega) {
    const nome = `${sanitizeName(partita_iva)}_Documento_di_Delega_${versione}.pdf`;
    await addToZip(root, file_delega, nome);
    window.allegatiSelezionati.push({ label: "Documento di Delega", nomeFile: nome });

  }

  // ===== ATTO COSTITUTIVO (Agricoltori Associati) =====
  const file_associati = document.getElementById("upload_associati")?.files?.[0];
  if (tipoBeneficiario === "associati" && file_associati) {
    const est = (file_associati.name.split('.').pop() || "").toLowerCase();
    const nome = `${sanitizeName(partita_iva)}_Atto_costitutivo.${sanitizeName(est)}`;
    await addToZip(root, file_associati, nome);
    window.allegatiSelezionati.push({ label: "Atto costitutivo", nomeFile: nome });

  }

  // ===== PERIZIA PROGETTISTA (se no-necessita) =====
  if (acquisizionePareriValue === "no-necessita") {
    const f = document.getElementById("perizia_progettista")?.files?.[0];
    if (f) {
      const est = (f.name.split('.').pop() || "").toLowerCase();
      const nome = `${sanitizeName(partita_iva)}_Perizia_Progettista_${versione}.${sanitizeName(est)}`;
      await addToZip(root, f, nome);
      // aggiungi alla lista per la stampa nel PDF
      window.allegatiSelezionati.push({
        label: "Perizia Progettista",
        nomeFile: nome
      });
    }
  }

  // ===== TITOLI ABILITATIVI (se necessita) =====
  if (acquisizionePareriValue === "necessita") {
    const inputsTitoli = document.querySelectorAll('input[type="file"][name="enti_preposti_file"]');
    let i = 1;
    for (const input of inputsTitoli) {
      const f = input.files?.[0];
      if (!f) continue;
      const titoloInput = input.closest(".ep-row")?.querySelector('input[id^="enti_preposti_input"]');
      const titolo = sanitizeName(titoloInput?.value || "SenzaTitolo");
      const est = (f.name.split(".").pop() || "").toLowerCase();
      const nome = `${sanitizeName(partita_iva)}_Richieste_Inoltrate_${titolo}_${i}_${versione}.${sanitizeName(est)}`;
      await addToZip(foldTitoli, f, nome);
      i++;
    }
  }

  // ===== COPIE FATTURE (tabella investimenti) =====
  const inputsFatture = document.querySelectorAll('#investimenti tbody input[type="file"][name="copia_fattura"]');
  let idxF = 1;
  for (const inp of inputsFatture) {
    const f = inp.files?.[0];
    if (!f) continue;
    const est = (f.name.split(".").pop() || "").toLowerCase();
    const nome = `${sanitizeName(partita_iva)}_Copia_Fattura_${idxF}_${versione}.${sanitizeName(est)}`;
    await addToZip(foldSpese, f, nome);
    idxF++;
  }

  // ===== PRIVACY POLICY (se link disponibile) =====
  const aPrivacy = document.getElementById('pdf_privacy_policy');
  if (aPrivacy && aPrivacy.href) {
    const privacyBlob = await fetchBlob(aPrivacy.href);
    if (privacyBlob) {
      await addToZip(root, privacyBlob, `${sanitizeName(partita_iva)}_Privacy_Policy_${versione}.pdf`);
    }
  }

  // ===== EXCEL (opzionale): se hai un generatore che restituisce un Blob
  // Implementazione facoltativa:
  // - Se esiste window.getExcelBlob(partita_iva) deve restituire una Promise<Blob>
  // - Altrimenti, mantenere la logica attuale (download esterno) oppure eliminare
  if (typeof window.getExcelBlob === "function") {
    try {
      const xBlob = await window.getExcelBlob(partita_iva, versione);
      if (xBlob) {
        await addToZip(root, xBlob, `${sanitizeName(partita_iva)}_Verbale_Di_Istruttoria_${versione}.xlsx`);
      }
    } catch (e) {
      console.warn("Excel non aggiunto allo ZIP:", e);
    }
  } else {
    // Se vuoi mantenere la vecchia funzione (che scarica a parte):
    crea_excel(partita_iva);
  }

  const pdfBlob = await crea_pdf_blob();
  await addToZip(root, pdfBlob, `${sanitizeName(partita_iva)}_Modulo_Saldo_${versione}.pdf`);

  // ===== GENERA E SCARICA LO ZIP =====
  const zipBlob = await zip.generateAsync({ type: "blob" });
  saveAs(zipBlob, `${sanitizeName(partita_iva)}_Saldo_${versione}.zip`);

});

/* =======================================================
   VALIDAZIONI E FUNZIONI ESISTENTI (riportate come in origine)
   ======================================================= */

function check_errors(fields, error_class, regex, error_regex_message, error_message) {
  var errors = 0;
  fields.each(function () {
    valida_campo($(this), error_class, regex, error_regex_message, error_message);
    if ($(this).next(error_class).hasClass("invalid-feedback")) {
      errors++;
    }
  });
  return errors;
}

function check_error(field, error_class, validation_func, isValue) {
  var error = 0;
  var value = isValue ? field.val() : field;
  validation_func(value);
  if (field.next(error_class).hasClass("invalid-feedback")) {
    error++;
  }
  return error;
}

function check_errori_firma() {
  var errori_firma = 0;
  var reg_luogo_nascita_residenza = /^[A-Za-zàèéìòùÀÈÉÌÒÙ\s\-']{2,}$/;
  var luogoFirma = $("#luogo_per_firma").val();
  if (luogoFirma.length == 0) {
    $("#luogo_per_firma").addClass("is-invalid");
    $("#errore_luogo_per_firma").addClass("invalid-feedback d-block");
    $("#errore_luogo_per_firma").text("Luogo obbligatorio.");
    errori_firma++;
  }
  else if (!reg_luogo_nascita_residenza.test(luogoFirma)) {
    $("#luogo_per_firma").addClass("is-invalid");
    $("#errore_luogo_per_firma").addClass("invalid-feedback d-block");
    $("#errore_luogo_per_firma").text("Luogo non valido.");
    errori_firma++;
  }
  else {
    $("#luogo_per_firma").removeClass("is-invalid");
    $("#errore_luogo_per_firma").removeClass("invalid-feedback");
    $("#errore_luogo_per_firma").text("");
  }

  var dataFirma = $("#data_per_firma").val();
  const array_data = dataFirma.split("-");
  var anno = array_data[0];
  if (dataFirma == "") {
    $("#data_per_firma").addClass("is-invalid");
    $("#errore_data_per_firma").addClass("invalid-feedback d-block");
    $("#errore_data_per_firma").text("Data firma obbligatoria.");
    errori_firma++;
  }
  else if (anno < 1900 || anno > 2026) {
    $("#data_per_firma").addClass("is-invalid");
    $("#errore_data_per_firma").addClass("invalid-feedback d-block");
    $("#errore_data_per_firma").text("Data firma non valida.");
    errori_firma++;
  }
  else {
    $("#data_per_firma").removeClass("is-invalid");
    $("#errore_data_per_firma").removeClass("invalid-feedback");
    $("#errore_data_per_firma").text("");
  }
  return errori_firma;
}

/*==== FUNZIONE CHECK PROVINCIA ISPETTORATO ====*/
function check_provincia_ispettorato() {
  const $sel = $("#selezione_province_ispettorato");
  const $err = $("#errore_selezione_ispettorato");

  // pulizia stato precedente
  $sel.removeClass("is-invalid");
  $err.removeClass("invalid-feedback d-block").text("");

  const val = ($sel.val() || "").toString().trim();

  if (val === "") {
    $sel.addClass("is-invalid");
    $err.addClass("invalid-feedback d-block").text("Seleziona la provincia.");

    // 🔥 scroll + focus sul campo
    $("html, body").animate({ scrollTop: $sel.offset().top - 150 }, 500, function () {
      // focus nativo
      $sel.trigger("focus");
      // se usi select2, apri il dropdown:
      // if ($sel.hasClass("select2-hidden-accessible")) $sel.select2("open");
    });

    return 1; // c'è errore
  }

  return 0; // ok
}
/*==== FUNZIONE CHECK PROVINCIA ISPETTORATO ====*/

/*==== FUNZIONE CHECK ANAGRAFICA ====*/
function check_sezione_anagrafica() {
  var errori_anagrafica = 0
  const tipo = get_tipo_beneficiario();

  var nome = $(`#nome_${tipo}`);
  var cognome = $(`#cognome_${tipo}`);
  var dataNascita = $(`#data-nascita_${tipo}`);
  var luogoNascita = $(`#luogo-nascita_${tipo}`);
  var provinciaNascita = $(`#provincia-nascita_${tipo}`);
  var residenza = $(`#residenza_${tipo}`);
  var provincia = $(`#provincia_${tipo}`);
  var indirizzo = $(`#indirizzo_${tipo}`);
  var civico = $(`#civico_${tipo}`);
  var email = $(`#email_${tipo}`);
  var pec = $(`#pec_${tipo}`);
  var telefono = $(`#telefono_${tipo}`);
  var cuua = $(`#cuua_${tipo}`);
  var sede = $(`#sede_${tipo}`);
  var sede_indirizzo = $(`#sede_indirizzo_${tipo}`);
  var civico_sede = $(`#civico_sede_${tipo}`);
  var denominazione = $(`#denominazione_${tipo}`);
  var sedeProvincia = $(`#sede_provincia_${tipo}`);
  var numero_imprese = $("#numero_imprese_agricole_associate");
  var codiceFiscale = $(`#codice_fiscale_${tipo}`);
  var cciaRiferimento = $("#ccia-riferimento");
  var numeroREA = $("#numero-rea");
  var comuneRiferimento = $("#comune_riferimento");

  errori_anagrafica += check_error(nome, `#errore_nome_${tipo}`, valida_nome, true);
  errori_anagrafica += check_error(cognome, `#errore_cognome_${tipo}`, valida_cognome, true);
  errori_anagrafica += check_error(dataNascita, `#errore_data_nascita_${tipo}`, valida_data_nascita, true);
  errori_anagrafica += check_error(luogoNascita, `#errore_luogo_nascita_${tipo}`, valida_luogo_nascita, true);
  errori_anagrafica += check_error(provinciaNascita, `#errore_provincia_nascita_${tipo}`, valida_provincia_nascita, true);
  errori_anagrafica += check_error(residenza, `#errore_residenza_${tipo}`, valida_residenza, true);
  errori_anagrafica += check_error(provincia, `#errore_provincia_${tipo}`, valida_provincia, true);
  errori_anagrafica += check_error(indirizzo, `#errore_indirizzo_${tipo}`, valida_indirizzo, true);
  errori_anagrafica += check_error(civico, `#errore_civico_${tipo}`, valida_civico, true);
  errori_anagrafica += check_error(email, `#errore_email_${tipo}`, valida_email, true);
  errori_anagrafica += check_error(pec, `#errore_pec_${tipo}`, valida_pec, true);
  errori_anagrafica += check_error(telefono, `#errore_telefono_${tipo}`, valida_telefono, true);
  errori_anagrafica += check_error(cuua, `#errore_cuua_${tipo}`, valida_cuua, true);
  errori_anagrafica += check_error(sede, `#errore_sede_${tipo}`, valida_sede, true);
  errori_anagrafica += check_error(sede_indirizzo, `#errore_sede_indirizzo_${tipo}`, valida_sede_indirizzo, true);
  errori_anagrafica += check_error(civico_sede, `#errore_civico_sede_${tipo}`, valida_sede_civico, true);
  errori_anagrafica += check_error(denominazione, `#errore_denominazione_${tipo}`, valida_denominazione, true);
  errori_anagrafica += check_error(sedeProvincia, `#errore_sede_provincia_${tipo}`, valida_sede_provincia, true);
  errori_anagrafica += check_error(numero_imprese, "#errore_numero_imprese_agricole_associate", valida_n_imprese, true);
  errori_anagrafica += check_error(codiceFiscale, `#errore_codice_fiscale_${tipo}`, valida_cf, true);
  errori_anagrafica += check_error(cciaRiferimento, "#errore_ccia_riferimento", valida_ccia, true);
  errori_anagrafica += check_error(numeroREA, "#errore_numero_rea", valida_rea, true);
  errori_anagrafica += check_error(comuneRiferimento, "#errore_comune_riferimento", valida_comune_riferimento, true);

  valida_qualifica();
  errori_anagrafica += $(`#errore_qualifica_${tipo}`).hasClass("invalid-feedback") ? 1 : 0;

  var string_errori = " errore";
  var string_verbo = " è ";
  if (errori_anagrafica > 1) {
    string_errori = " errori";
    string_verbo = " sono "
  }
  $(`#validazione_sezione_anagrafica_${tipo}`).removeClass("badge text-bg-success");
  $(`#validazione_sezione_anagrafica_${tipo}`).removeClass("badge text-bg-error");
  $(`#anagrafica_${tipo} .accordion-header button`).removeClass("background-color-success-accordion");
  $(`#anagrafica_${tipo} .accordion-header button`).removeClass("background-color-error-accordion");
  if (errori_anagrafica == 0) {
    $(`#validazione_sezione_anagrafica_${tipo}`).text("Sezione Compilata Correttamente");
    $(`#validazione_sezione_anagrafica_${tipo}`).addClass("badge text-bg-success");
    $(`#anagrafica_${tipo} .accordion-header button`).addClass("background-color-success-accordion");
  }
  else {
    $(`#validazione_sezione_anagrafica_${tipo}`).text("Vi " + string_verbo + errori_anagrafica + string_errori);
    $(`#validazione_sezione_anagrafica_${tipo}`).addClass("badge text-bg-error");
    $(`#anagrafica_${tipo} .accordion-header button`).addClass("background-color-error-accordion");
  }
  return errori_anagrafica;
}
/*==== FUNZIONE CHECK ANAGRAFICA ====*/
// --- VALIDAZIONE ATTO COSTITUTIVO (GLOBALE)
/*==== FUNZIONE CHECK ANAGRAFICA ====*/
// --- VALIDAZIONE ATTO COSTITUTIVO (SOLO SU "CREA FILES") ---
function check_atto_costitutivo_associati() {
  const tipo = $("input[name='tipo_beneficiario']:checked").val();
  const $inp = $("#upload_associati");
  const $err = $("#errore_upload_associati");

  // pulizia iniziale
  $inp.removeClass("is-invalid");
  $err.removeClass("invalid-feedback d-block").text("");

  // obbligatorio SOLO per associati
  if (tipo !== "associati") return 0;

  const file = $inp[0]?.files?.[0];
  const manca = !file;

  // se manca, errore
  if (manca) {
    $inp.addClass("is-invalid");
    $err.addClass("invalid-feedback d-block").text("Carica l'Atto costitutivo (PDF, max 5MB).");

    // 🔥 Apri la sezione dell’accordion
    const collapse = $inp.closest(".accordion-collapse");
    if (collapse.length) {
      const collapseId = collapse.attr("id");
      const btn = document.querySelector(
        `button[data-bs-target="#${collapseId}"], button[aria-controls="${collapseId}"]`
      );
      btn?.click();
    }

    // 🔥 Scroll sul campo mancante
    $("html, body").animate({
      scrollTop: $inp.offset().top - 150
    }, 500);

    return 1;
  }

  return 0;
}

// Solo filtro input (NON validazione live)
$(document).ready(function () {
  $("#upload_associati").attr("accept", "application/pdf,.pdf");
});
/*==== FUNZIONE CHECK LOCALIZZAZIONE INVESTIMENTO ====*/
function check_sezione_localizzazione_investimento() {
  var reg_foglio = /^\d{1,4}$/;
  var reg_particella = /^[a-zA-Z0-9]{1,5}(, ?[a-zA-Z0-9]{1,5})*$/;
  var errori_localizzazione_investimento = 0;

  // Provincia
  var provinciaLocalizzazione = $("#provincia-localizzazione").val();
  if (!provinciaLocalizzazione) {
    $("#provincia-localizzazione").addClass("is-invalid");
    $("#errore_provincia_localizzazione").addClass("invalid-feedback").text("Provincia di localizzazione obbligatoria.");
    errori_localizzazione_investimento++;
  } else {
    $("#provincia-localizzazione").removeClass("is-invalid");
    $("#errore_provincia_localizzazione").removeClass("invalid-feedback").text("");
  }

  // Comuni
  $("[id^=comune-localizzazione]").each(function () {
    var comune = $(this).val();
    var id = $(this).attr("id");
    var suffix = id.substring("comune-localizzazione".length);
    var erroreComune = $("#errore_comune_localizzazione" + suffix);

    if ($(this).find("option").length === 0) {
      $(this).addClass("is-invalid");
      erroreComune.addClass("invalid-feedback").text("Seleziona prima la provincia.");
      errori_localizzazione_investimento++;
    } else if (!comune || comune.length === 0) {
      $(this).addClass("is-invalid");
      erroreComune.addClass("invalid-feedback").text("Comune di localizzazione obbligatorio.");
      errori_localizzazione_investimento++;
    } else {
      $(this).removeClass("is-invalid");
      erroreComune.removeClass("invalid-feedback").text("");
    }
  });


  // Fogli
  $("[id^=foglio]").each(function () {
    var foglio = $(this).val();
    var id = $(this).attr("id");
    var suffix = id.substring("foglio".length);
    var erroreFoglio = $("#errore_foglio" + suffix);

    if (!foglio) {
      $(this).addClass("is-invalid");
      erroreFoglio.addClass("invalid-feedback").text("Foglio di riferimento dell'immobile obbligatorio.");
      errori_localizzazione_investimento++;
    } else if (!reg_foglio.test(foglio)) {
      $(this).addClass("is-invalid");
      erroreFoglio.addClass("invalid-feedback").text("Foglio di riferimento non valido.");
      errori_localizzazione_investimento++;
    } else {
      $(this).removeClass("is-invalid");
      erroreFoglio.removeClass("invalid-feedback").text("");
    }
  });

  // Particelle
  $("[id^=particella]").each(function () {
    var particella = $(this).val();
    var id = $(this).attr("id");
    var suffix = id.substring("particella".length);
    var erroreParticella = $("#errore_particella" + suffix);

    if (!particella) {
      $(this).addClass("is-invalid");
      erroreParticella.addClass("invalid-feedback").text("Particella di riferimento dell'immobile obbligatoria.");
      errori_localizzazione_investimento++;
    } else if (!reg_particella.test(particella)) {
      $(this).addClass("is-invalid");
      erroreParticella.addClass("invalid-feedback").text("Particella di riferimento non valida.");
      errori_localizzazione_investimento++;
    } else {
      $(this).removeClass("is-invalid");
      erroreParticella.removeClass("invalid-feedback").text("");
    }
  });

  // Aggiorna badge e colore header
  var string_errori = errori_localizzazione_investimento === 1 ? " errore" : " errori";
  var string_verbo = errori_localizzazione_investimento === 1 ? " è " : " sono ";

  $("#validazione_sezione_localizzazione_investimento").removeClass("badge text-bg-success text-bg-error");
  $("#localizzazione-investimento .accordion-header button").removeClass("background-color-success-accordion background-color-error-accordion");

  if (errori_localizzazione_investimento === 0) {
    $("#validazione_sezione_localizzazione_investimento").text("Sezione Compilata Correttamente").addClass("badge text-bg-success");
    $("#localizzazione-investimento .accordion-header button").addClass("background-color-success-accordion");
  } else {
    $("#validazione_sezione_localizzazione_investimento").text("Vi " + string_verbo + errori_localizzazione_investimento + string_errori).addClass("badge text-bg-error");
    $("#localizzazione-investimento .accordion-header button").addClass("background-color-error-accordion");
  }

  return errori_localizzazione_investimento;
}
/*==== FUNZIONE CHECK LOCALIZZAZIONE INVESTIMENTO ====*/

/*==== FUNZIONE CHECK CANTIERABILITA' ====*/
function check_sezione_cantierabilita() {
  var errori_cantierabilita = 0;
  const acquisizionePareriValue = $("input[name='acquisizione-pareri']:checked").val();

  // Obbligo scelta opzione
  if (!acquisizionePareriValue) {
    $("#acquisizione-pareri").addClass("is-invalid");
    $("#errore_acquisizione_pareri")
      .addClass("invalid-feedback")
      .text("Scegli un'opzione.");
    errori_cantierabilita++;
  } else {
    $("#acquisizione-pareri").removeClass("is-invalid");
    $("#errore_acquisizione_pareri")
      .removeClass("invalid-feedback")
      .text("");
  }

  // Caso 1: immediatamente cantierabile → perizia obbligatoria
  if (acquisizionePareriValue === "no-necessita") {
    const file = $("#perizia_progettista")[0]?.files[0];
    if (!file || !(file.type === "application/pdf" || /\.pdf$/i.test(file.name))) {
      $("#perizia_progettista").addClass("is-invalid");
      $("#errore_perizia_progettista")
        .addClass("invalid-feedback")
        .text("Carica un PDF valido.");
      errori_cantierabilita++;
    } else {
      $("#perizia_progettista").removeClass("is-invalid");
      $("#errore_perizia_progettista")
        .removeClass("invalid-feedback")
        .text("");
    }
  }

  // Caso 2: titoli già rilasciati → prima riga obbligatoria
  if (acquisizionePareriValue === "necessita") {
    const titolo = $("#enti_preposti_input").val().trim();
    const file = $("#enti_preposti_file")[0]?.files[0];

    if (titolo === "") {
      $("#enti_preposti_input").addClass("is-invalid");
      $("#errore_enti_preposti_input")
        .addClass("invalid-feedback")
        .text("Titolo obbligatorio.");
      errori_cantierabilita++;
    } else {
      $("#enti_preposti_input").removeClass("is-invalid");
      $("#errore_enti_preposti_input")
        .removeClass("invalid-feedback")
        .text("");
    }

    if (!file) {
      $("#enti_preposti_file").addClass("is-invalid");
      $("#errore_enti_preposti_file")
        .addClass("invalid-feedback")
        .text("Allega il documento.");
      errori_cantierabilita++;
    } else {
      $("#enti_preposti_file").removeClass("is-invalid");
      $("#errore_enti_preposti_file")
        .removeClass("invalid-feedback")
        .text("");
    }
  }

  // Aggiornamento badge sezione
  const elBadge = $("#validazione_sezione_cantierabilita");
  const headerBtn = $("#cantierabilita .accordion-header button");
  elBadge.removeClass("text-bg-success text-bg-error").addClass("badge");
  headerBtn.removeClass("background-color-success-accordion background-color-error-accordion");

  if (errori_cantierabilita === 0) {
    elBadge.addClass("text-bg-success").text("Sezione Compilata Correttamente");
    headerBtn.addClass("background-color-success-accordion");
  } else {
    const string_errori = errori_cantierabilita === 1 ? " errore" : " errori";
    const string_verbo = errori_cantierabilita === 1 ? " è " : " sono ";
    elBadge
      .addClass("text-bg-error")
      .text("Vi " + string_verbo + errori_cantierabilita + string_errori);
    headerBtn.addClass("background-color-error-accordion");
  }

  return errori_cantierabilita;
}
/*==== FUNZIONE CHECK CANTIERABILITA' ====*/

/*==== FUNZIONE CHECK PRIVACY ====*/
function check_sezione_privacy() {
  var errori_privacy = 0;
  var valore = $("input[name=checkbox-policy]").val();
  if (valore == 1) {
    $(this).removeClass("is-invalid");
    $("#errore_accettazione_privacy").removeClass("invalid-feedback");
    $("#errore_accettazione_privacy").text("");
  } else {
    $(this).addClass("is-invalid");
    $("#errore_accettazione_privacy").addClass("invalid-feedback");
    $("#errore_accettazione_privacy").text("Devi accettare obbligatoriamente la privacy policy.");
    errori_privacy++;
  }
  var string_errori = " errore";
  var string_verbo = " è ";
  if (errori_privacy > 1) {
    string_errori = " errori";
    string_verbo = " sono "
  }

  $("#validazione_sezione_privacy_policy").removeClass("badge text-bg-error");
  $("#validazione_sezione_privacy_policy").removeClass("badge text-bg-success");
  $("#privacy-policy .accordion-header button").removeClass("background-color-error-accordion");
  $("#privacy-policy .accordion-header button").removeClass("background-color-success-accordion");
  if (errori_privacy == 0) {
    $("#validazione_sezione_privacy_policy").text("Sezione Compilata Correttamente");
    $("#validazione_sezione_privacy_policy").addClass("badge text-bg-success");
    $("#privacy-policy .accordion-header button").addClass("background-color-success-accordion");
  }
  else {
    $("#validazione_sezione_privacy_policy").text("Vi " + string_verbo + errori_privacy + string_errori);
    $("#privacy-policy .accordion-header button").addClass("background-color-error-accordion");
  }

  return errori_privacy;
}
/*==== FUNZIONE CHECK PRIVACY ====*/
function validaSezioneDocumentazione() {
  let errori = 0;

  const campi = [
    ["doc_identita", "Documento d’identità"],
    ["delibera_associazione", "Delibera associazione/società"],
    ["relazione_tecnica", "Relazione tecnica finale"],
    ["computo_consuntivo", "Computo metrico consuntivo"],
    ["elaborati_tecnici", "Elaborati tecnici"],
    ["elenco_fatture", "Elenco delle fatture"],
    ["registro_iva", "Registro IVA"],
    ["fatture_elettroniche", "Fatture elettroniche"],
    ["bonifici", "Bonifici o ricevute"],
    ["estratti_conto", "Estratti conto corrente"],
    ["quietanza_fornitori", "Quietanza fornitori"],
    ["dichiarazione_tecnico", "Dichiarazione tecnico/direttore"],
    ["foto_investimenti", "Foto georeferenziate"],
    ["certificazione_conformita", "Certificazione conformità CE"],
    ["dichiarazione_impegno", "Dichiarazione di impegno"]
  ];

  const obbligatori = new Set([
    "doc_identita",
    "relazione_tecnica",
    "computo_consuntivo",
    "elenco_fatture",
    "fatture_elettroniche",
    "bonifici",
    "estratti_conto",
    "quietanza_fornitori",
    "dichiarazione_tecnico",
    "foto_investimenti",
    "dichiarazione_impegno"
  ]);

  const MAX_MB = 5;
  const MAX_BYTES = MAX_MB * 1024 * 1024;

  const $sezione = $("#allegati-saldo-finale");
  $sezione.find("input[type=file]").removeClass("is-invalid");
  $sezione.find(".invalid-feedback").remove();
  $sezione.find(".mb-3").removeClass("error-block");

  for (const [id, label] of campi) {
    const el = document.getElementById(id);
    if (!el) {
      console.warn("Campo file non trovato:", "#" + id);
      continue;
    }

    const file = el.files[0];
    const fileMancante = !file;
    const nonPdf = file && el.accept?.includes(".pdf") && !/\.pdf$/i.test(file.name);
    const overSize = file && file.size > MAX_BYTES;

    if ((obbligatori.has(id) && fileMancante) || nonPdf || overSize) {
      errori++;
      const $inp = $(el);
      let msg = "";

      if (fileMancante && obbligatori.has(id)) {
        msg = `Carica il file: ${label}.`;
      } else if (nonPdf) {
        msg = `Formato non valido: caricare un PDF.`;
      } else if (overSize) {
        msg = `Il file "${file.name}" supera ${MAX_MB} MB: riduci la dimensione.`;
      }

      $inp.addClass("is-invalid");
      $inp.after(`<div class="invalid-feedback d-block">${msg}</div>`);
      $inp.closest(".mb-3").addClass("error-block");
    }
  }

  const $badge = $("#validazione_sezione_documentazione");
  const $button = $("#allegati-saldo-finale .accordion-header button");
  $badge.removeClass("text-bg-success text-bg-error");
  $button.removeClass("background-color-success-accordion background-color-error-accordion");

  if (errori === 0) {
    $badge.text("Sezione Compilata Correttamente").addClass("text-bg-success");
    $button.addClass("background-color-success-accordion");
  } else {
    const suff = errori === 1 ? " errore" : " errori";
    const verbo = errori === 1 ? " è " : " sono ";
    $badge.text("Vi " + verbo + errori + suff).addClass("text-bg-error");
    $button.addClass("background-color-error-accordion");
  }

  return errori;
}

function getFormattedDate(date) {
  var date = date.split("-");
  var anno = date[0];
  var mese = date[1];
  var giorno = date[2];
  return giorno + '/' + mese + '/' + anno;
}

/* ==== UTILITIES per numeri (mettile una sola volta nel file) ==== */
function parseNum(v) {
  if (v == null) return 0;
  const s = String(v).trim();
  if (!s) return 0;
  // tieni solo cifre, punti e virgole; trasforma virgola in punto
  const clean = s.replace(/[^\d.,-]/g, '').replace(',', '.');
  const n = Number(clean);
  return isNaN(n) ? 0 : n;
}
function fmt2(n) {
  if (n == null || isNaN(n)) return '';
  const val = Math.round(Number(n) * 100) / 100;
  // Se è intero → niente decimali
  if (Number.isInteger(val)) return val.toString();
  // Se ha decimali → massimo 2
  return val.toFixed(2).replace(/\.00$/, '');
}
/* ==========================================
   CREAZIONE PDF → restituisce un Blob (no save)
   ========================================== */

async function crea_pdf_blob() {
  const { jsPDF } = window.jspdf;
  const doc = new jsPDF();



  // --- FOOTER UNICO (pagina a sx, versione a dx) ---
  function drawFooterAllPages() {
    const versione = $("#versione").val() || "";
    const pageCount = doc.getNumberOfPages();
    const w = doc.internal.pageSize.getWidth();
    const h = doc.internal.pageSize.getHeight();
    const marginX = 13;
    const y = h - 10; // margine basso

    for (let p = 1; p <= pageCount; p++) {
      doc.setPage(p);

      // riga separatrice
      doc.setDrawColor(200);
      doc.line(marginX, y - 6, w - marginX, y - 6);

      doc.setFont('PTSans', 'italic');
      doc.setFontSize(9);
      doc.setTextColor(100);

      doc.text(`Pagina ${p} di ${pageCount}`, marginX, y); // sinistra
      doc.text(`Modello di domanda di liquidazione saldo v.${versione}`, w - marginX, y, { align: 'right' }); // destra

      // reset
      doc.setTextColor(0);
      doc.setDrawColor(0);
    }
  }
  /* ------------------------------------------
   * RACCOGLI DATI TECNICO (interno/esterno)
   * ------------------------------------------ */
  function raccogliDatiTecnico() {
    // "Tecnico Esterno" | "Tecnico Interno"
    const tipoRaw = $('input[name="tipo_tecnico"]:checked').val() || "";
    const esterno = /esterno/i.test(tipoRaw); // true se è Tecnico Esterno

    const T = {};

    // Campi comuni
    T.nome = $('#nome-tecnico').val() || "";
    T.cognome = $('#cognome-tecnico').val() || "";
    T.telefono = $('#recapito-tecnico').val() || "";
    T.pec = $('#pec-tecnico').val() || "";
    T.email = $('#mail-tecnico').val() || "";

    // Dati sede/indirizzo (letti sempre)
    T.comuneStudio = $('#comune-studio-professionale').val() || "";
    T.provinciaStudio = $('#provincia-studio-professionale').val() || "";
    T.indirizzoStudio = $('#indirizzo-studio-professionale').val() || "";
    T.civicoStudio = $('#civico-studio-professionale').val() || "";

    if (esterno) {
      // Esterno → ordine e numero di iscrizione
      T.provOrdine = $('#provincia-ordine-tecnico').val() || "";
      T.ordine = $('#ordine-tecnico').val() || "";
      T.numeroIscrizione = $('#numero-iscrizione-ordine-tecnico').val() || "";
      T.ruolo = ""; // non usato
    } else {
      // Interno → ruolo/incarico
      T.ruolo = $('#tipologia_incarico').val() || "";
      T.provOrdine = "";
      T.ordine = "";
      T.numeroIscrizione = "";
    }

    T.tipo = esterno ? "Tecnico Esterno" : "Tecnico Interno";
    return T;
  }

  /* ------------------------------------------
   * FOOTER PAGINE
   * ------------------------------------------ */
  function footer() {
    doc.setFont('PTSans', 'italic');

    if ($("#luogo_per_firma").val() !== "") {
      const luogo_firma = $("#luogo_per_firma").val();
      const data_firma = getFormattedDate($("#data_per_firma").val());
      doc.text(13, 220, 'Li ' + luogo_firma + '     Data ' + data_firma);
    } else {
      doc.text(13, 220, 'Li ___________________     Data ___________________');
    }

    doc.text(30, 240, 'Firma del Tecnico*');
    doc.text(120, 240, 'Firma del Beneficiario');
    doc.text(13, 270, '*Nella certezza di avere applicato al meglio le mie capacità professionali nella redazione della presente perizia,');
    doc.text(13, 275, 'confermo, sotto la mia responsabilità, l’autenticità e la certezza dei contenuti della relazione.');
  }


  /* ------------------------------------------
   * LETTURA DATI BENEFICIARIO
   * ------------------------------------------ */
  const nome = $(`#nome_${get_tipo_beneficiario()}`).val();
  const cognome = $(`#cognome_${get_tipo_beneficiario()}`).val();
  const dataNascita = $(`#data-nascita_${get_tipo_beneficiario()}`).val();
  const luogoNascita = $(`#luogo-nascita_${get_tipo_beneficiario()}`).val();
  const provinciaNascita = $(`#provincia-nascita_${get_tipo_beneficiario()}`).val();
  const residenza = $(`#residenza_${get_tipo_beneficiario()}`).val();
  const provincia = $(`#provincia_${get_tipo_beneficiario()}`).val();
  const indirizzo = $(`#indirizzo_${get_tipo_beneficiario()}`).val();
  const civico = $(`#civico_${get_tipo_beneficiario()}`).val();
  const email = $(`#email_${get_tipo_beneficiario()}`).val();
  const pec = $(`#pec_${get_tipo_beneficiario()}`).val();
  const telefono = $(`#telefono_${get_tipo_beneficiario()}`).val();
  const cuua = $(`#cuua_${get_tipo_beneficiario()}`).val();
  const sede = $(`#sede_${get_tipo_beneficiario()}`).val();
  const sede_indirizzo = $(`#sede_indirizzo_${get_tipo_beneficiario()}`).val();
  const sede_civico = $(`#civico_sede_${get_tipo_beneficiario()}`).val();
  const denominazione = $(`#denominazione_${get_tipo_beneficiario()}`).val();
  const ccia_riferimento = $("#ccia-riferimento").val();
  const numero_rea = $("#numero-rea").val();
  const numero_inps = $("#numero-inps").val();
  const iban = $("#iban").val();
  const istituto_credito = $("#istituto-credito").val();
  const agenzia_banca = $("#agenzia_banca").val();
  const sede_provincia = $(`#sede_provincia_${get_tipo_beneficiario()}`).val();
  const comuneRiferimento = residenza || "";

  const qualifica = $(`input[name=qualifica_${get_tipo_beneficiario()}]:checked`).val();
  const ispettorato = $("#selezione_province_ispettorato option:selected").text();
  const ispettorato_split = ispettorato.split("-");
  const ispettorato_provincia = ispettorato_split[0];
  const ispettorato_mail = ispettorato_split[1];

  /* ------------------------------------------
   * LOCALIZZAZIONI & TABELLA INVESTIMENTI
   * ------------------------------------------ */
  const numeroLocalizzazioni = $("#numero_localizzazioni_investimenti").val();
  const comuniLocalizzazioni = [$("#comune-localizzazione").val()];
  const provinciaLocalizzazione = $("#provincia-localizzazione option:selected").text();
  const fogli = [$("#foglio").val()];
  const particelle = [$("#particella").val()];

  for (let i = 2; i <= numeroLocalizzazioni; i++) {
    comuniLocalizzazioni.push($("#comune-localizzazione_" + i).val());
    fogli.push($("#foglio_" + i).val());
    particelle.push($("#particella_" + i).val());
  }



  /* ==== TABELLA LIQUIDAZIONE DELLE SPESE (dal DOM) ==== */
  // intestazioni nel PDF (stesso ordine che vuoi stampare)
  const headCols = [
    "Categoria Interventi",
    "Fattura Numero",
    "Emittente Fattura",
    "Descrizione Fattura",
    "Importo Imponibile €",
    "Importo Ivato €",
    "Contributo richiesto €"
  ];
  // costruisci le righe leggendo il tbody della tua tabella
  const bodyRows = [];
  $("#investimenti tbody tr[id^='categoria_interventi_']").each(function () {
    const $tr = $(this);
    const categoria = $tr.find("select[name='categoria_interventi'] option:selected").text().trim();
    const nFatt = ($tr.find("input[name='n_fattura']").val() || "").trim();
    const emitt = ($tr.find("input[name='emittente_fattura']").val() || "").trim();
    const descr = ($tr.find("input[name='descrizione_fattura']").val() || "").trim();
    const impon = parseNum($tr.find("input[name='importo_imponibile']").val());
    const ivato = parseNum($tr.find("input[name='importo_ivato']").val());
    const contrib = parseNum($tr.find("input[name='contributo_richiesto']").val());

    bodyRows.push([
      categoria,
      nFatt,
      emitt,
      descr,
      fmt2(impon),
      fmt2(ivato),
      fmt2(contrib)
    ]);
  });

  // Calcoliamo noi i totali direttamente dai dati inseriti
  let impTot = 0;
  let ivaTot = 0;
  let contrTot = 0;

  $("#investimenti tbody tr[id^='categoria_interventi_']").each(function () {
    const $tr = $(this);
    impTot += parseNum($tr.find("input[name='importo_imponibile']").val()) || 0;
    ivaTot += parseNum($tr.find("input[name='importo_ivato']").val()) || 0;
    contrTot += parseNum($tr.find("input[name='contributo_richiesto']").val()) || 0;
  });

  bodyRows.push([
    "Totale", "", "", "",
    fmt2(impTot),
    fmt2(ivaTot),
    fmt2(contrTot)
  ]);
  /* ------------------------------------------
   * HEADER / LOGHI / TITOLI
   * ------------------------------------------ */
  const img = $("#png_regione_siciliana").attr("src");
  if (img) {
    try { doc.addImage(img, 'png', 93, 5, 24, 30); } catch (e) { /* ignore */ }
  }

  doc.setFontSize('12');
  doc.setFont('PTSans', 'italic');
  doc.text("Regione Siciliana", 105, 38, 'center', '');

  // Titoli
  const titolo_nuovo_prima_riga = "ASSESSORATO REGIONALE DELL’AGRICOLTURA, DELLO SVILUPPO";
  const titolo_nuovo_seconda_riga = "RURALE E DELLA PESCA MEDITERRANEA";
  const titolo_nuovo_terza_riga = "DIPARTIMENTO REGIONALE DELL’AGRICOLTURA";
  doc.text(titolo_nuovo_prima_riga, 104, 45, 'center', '');
  doc.text(titolo_nuovo_seconda_riga, 104, 50, 'center');
  doc.text(titolo_nuovo_terza_riga, 104, 55, 'center');

  let titolo_prima_riga = "Interventi in conto capitale per fronteggiare la crisi idrica in agricoltura";
  titolo_prima_riga += " in attuazione dell’art.13 della legge";
  const titolo_seconda_riga = " regionale 4 luglio 2024, n.23. Avviso approvato con D.D.G. n. 6186 del 29/08/2024.";
  doc.setFont('PTSans', 'normal');
  doc.setFontSize('12');
  doc.text(titolo_prima_riga, 12, 65);
  doc.text(titolo_seconda_riga, 11, 70);

  doc.setFont('PTSans', 'bold');
  doc.setFontSize('12');
  doc.text(`Format richiesta di liquidazione saldo finale per ${get_tipo_beneficiario()}`, 104, 80, 'center', '');
  doc.text("ISPETTORATO AGRICOLTURA DI " + (ispettorato_provincia || "").toUpperCase(), 100, 90, 'left');
  doc.text(ispettorato_mail || "", 99, 95, 'left');

  /* ------------------------------------------
   * SEZIONE ANAGRAFICA
   * ------------------------------------------ */
  let currentY = 105;
  let sumY = 7;
  let x = 13;

  doc.text("SEZIONE ANAGRAFICA", 104, currentY, 'center', '');
  doc.setFont('PTSans', 'normal');
  doc.setFontSize('12');

  doc.text("Il/La sottoscritto/a:", x, (currentY += sumY));
  doc.text("Nome:  " + (nome || ""), x, (currentY += sumY));
  doc.text("Cognome:  " + (cognome || ""), 75, currentY);
  if (dataNascita) doc.text("Data di nascita:  " + getFormattedDate(dataNascita), x, (currentY += sumY));
  doc.text("Luogo di nascita:  " + (luogoNascita || "") + " (" + (provinciaNascita || "") + ")", x, (currentY += sumY));
  doc.text("CUAA:  " + (cuua || ""), x, (currentY += sumY));
  doc.text("residente a:  " + (residenza || "") + " (" + (provincia || "") + ")", x, (currentY += sumY));
  doc.text("Indirizzo:  " + (indirizzo || "") + " n." + (civico || ""), x, (currentY += sumY));
  doc.text("Email Aziendale:  " + (email || ""), x, (currentY += sumY));
  doc.text("PEC Aziendale:  " + (pec || ""), x, (currentY += sumY));
  doc.text("Telefono/Cellulare:  " + (telefono || ""), x, (currentY += sumY));
  doc.text("Qualifica:  " + (qualifica || ""), x, (currentY += sumY));
  doc.text("Denominazione:  " + (denominazione || ""), x, (currentY += sumY));
  doc.text("Comune di riferimento:  " + (comuneRiferimento || ""), x, (currentY += sumY));
  doc.text("Sede Legale in:  " + (sede || "") + ", " + (sede_indirizzo || "") + " n. " + (sede_civico || ""), x, (currentY += sumY));



  const _tb = get_tipo_beneficiario();
  // CCIAA / REA / INPS
  if (_tb === 'singoli') {
    // CCIAA / REA / INPS
    doc.text("Impresa agricola iscritta alla Camera di Commercio, Industria, Artigianato e Agricoltura (CCIAA),", x, (currentY += sumY));
    doc.text("di " + (ccia_riferimento || "") + " al numero REA " + (numero_rea || "") + ";", x, (currentY += sumY));
    doc.text("Impresa iscritta all'INPS al numero " + (numero_inps || "") + ";", x, (currentY += sumY));
  }
  // Dati bancari
  doc.text("IBAN:  " + (iban || ""), x, (currentY += sumY));
  doc.text("Istituto di Credito:  " + (istituto_credito || ""), x, (currentY += sumY));
  doc.text("Agenzia:  " + (agenzia_banca || ""), x, (currentY += sumY));
  doc.text("Dichiara di confermare gli impegni già assunti e la veridicità delle dichiarazioni già rese in sede", x, (currentY += sumY));
  doc.text("di presentazione della domanda di sostegno.", x, (currentY += sumY));
  /* ------------------------------------------
* SEZIONE PIANO DEGLI INVESTIMENTI (paragrafo tecnico)
* ------------------------------------------ */
  const TEC = raccogliDatiTecnico();
  let par = "";

  if (TEC.tipo === "Tecnico Interno") {
    par = `Il tecnico ${TEC.nome} ${TEC.cognome}`
      + (TEC.ruolo ? `, ${TEC.ruolo}` : "")
      + `, telefono/cellulare ${TEC.telefono || "-"}, PEC ${TEC.pec || "-"}, email ${TEC.email || "-"}`
      + `, in esecuzione dell’incarico conferito dalla ditta di cui sopra, redige la presente perizia tecnico economica redatta nella forma di perizia asseverata in ottemperanza a quanto previsto dal bando "AVVISO PUBBLICO" Interventi in conto capitale per fronteggiare la crisi idrica in agricoltura in attuazione dell’articolo 13 della Legge Regionale 4 Luglio 2024, n. 23 approvato con D.D.G. n. 6186 del 29/08/2024.`;
  } else {
    par = `Il tecnico ${TEC.nome} ${TEC.cognome}, con studio professionale nel comune di ${TEC.comuneStudio || "-"} (${TEC.provinciaStudio || "-"}), ${TEC.indirizzoStudio || "-"} n.${TEC.civicoStudio || "-"}, telefono/cellulare ${TEC.telefono || "-"}, PEC ${TEC.pec || "-"}, email ${TEC.email || "-"}`;
    if (TEC.ordine) {
      par += `, iscritto all’Ordine/Albo degli/dei ${TEC.ordine}${TEC.provOrdine ? " (" + TEC.provOrdine + ")" : ""} al n. ${TEC.numeroIscrizione || "-"}`;
    }
    par += `, in esecuzione dell’incarico conferito dalla ditta di cui sopra, redige la presente perizia tecnico economica redatta nella forma di perizia asseverata in ottemperanza a quanto previsto dal bando AVVISO PUBBLICO Interventi in conto capitale per fronteggiare la crisi idrica in agricoltura in attuazione dell’articolo 13 della Legge Regionale 4 Luglio 2024, n. 23 approvato con D.D.G. n. 6186 del 29/08/2024.`;
  }

  const righePar = doc.splitTextToSize(par, 180);

  // helper: stampa il titolo della sezione una sola volta
  let titoloPIStampato = false;
  function stampaTitoloPI() {
    if (titoloPIStampato) return;
    doc.setFont('PTSans', 'bold');
    doc.text("SEZIONE PIANO DEGLI INVESTIMENTI", 104, (currentY += 10), 'center', '');
    doc.setFont('PTSans', 'normal');
    titoloPIStampato = true;
  }

  // Se NON ci sta nella prima pagina, chiudi la prima e vai in seconda
  if (currentY + righePar.length * sumY > 270) {
    doc.setFont('PTSans', 'italic');
    doc.addPage();
    currentY = 20;
    // Stampa il titolo in cima alla nuova pagina
    stampaTitoloPI();
  } else {
    // Ci sta in prima pagina → stampa il titolo qui
    stampaTitoloPI();
  }

  // Ora stampa il paragrafo (in prima o seconda pagina a seconda del caso)
  doc.text(righePar, x, (currentY += sumY));
  currentY += (righePar.length - 1) * sumY;


  // === DICHIARA ===
  doc.setFont('PTSans', 'bold');
  currentY += 10; // invece di 45 → distanza minima e controllata
  doc.text("DICHIARA", 104, currentY, 'center', '');
  doc.setFont('PTSans', 'normal');

  for (let i = 0; i < numeroLocalizzazioni; i++) {
    doc.text("- che l’investimento è localizzato nel comune di " + (comuniLocalizzazioni[i] || "") + " (" + (provinciaLocalizzazione || "") + "),", x, (currentY += 7));
    doc.text("  foglio " + (fogli[i] || "") + " particelle " + (particelle[i] || "") + ".", x, (currentY += 7));
  }

  // titolo + stampa tabella
  doc.setFont('PTSans', 'bold');
  doc.text("Tab. - Sezione Liquidazione delle Spese", x, (currentY += 9));
  doc.setFont('PTSans', 'normal');

  if (doc.autoTable) {
    doc.autoTable({
      startY: currentY + 5,
      head: [headCols],
      body: bodyRows,
      styles: { font: 'PTSans', fontSize: 10, cellPadding: 2, valign: 'middle' },
      headStyles: { fillColor: [191, 191, 191], halign: 'center' },
      bodyStyles: { halign: 'center' },
      columnStyles: {
        4: { halign: 'right' }, // Importo Imponibile €
        5: { halign: 'right' }, // Importo Ivato €
        6: { halign: 'right' }  // Contributo richiesto €
      }
    });
    currentY = doc.lastAutoTable ? (doc.lastAutoTable.finalY || currentY + 10) : currentY + 10;
  }

  // --- BLOCCO DRS: stampa sotto la tabella spese (prima della nota) ---
  (function printDRSBlock() {
    // leggi i campi dal DOM
    const drsNum = ($("#numeroDRS").val() || "").trim();
    const drsDataISO = ($("#dataDRS").val() || "").trim(); // atteso "YYYY-MM-DD"
    const drsImporto = parseNum($("#importoAmmissibile").val());

    // se non c'è nulla, esci senza stampare
    if (!drsNum && !drsDataISO && !(Number.isFinite(drsImporto) && drsImporto !== 0)) return;

    const pageW = doc.internal.pageSize.getWidth();
    const pageH = doc.internal.pageSize.getHeight();

    const leftX = 13;           // margine sinistro
    const rightX = pageW - leftX;
    const lineH = 7;            // interlinea
    const pad = 4;              // padding riquadro
    const rows = 1 /*titolo*/ + 3 /*righe*/;
    const blockH = pad * 2 + (rows * lineH) + 2;

    // se non ci sta in pagina, nuova pagina
    if (currentY + 10 + blockH > pageH - 20) {
      doc.addPage();
      currentY = 20;
    }

    currentY += 8; // distacco dalla tabella

    doc.setDrawColor(180);
    doc.rect(leftX, currentY, rightX - leftX, blockH);      // bordo

    // titolo
    let y = currentY + pad + 2;
    doc.setFont('PTSans', 'bold');
    doc.text(
      "DATI RELATIVI AL DRS (PROVVEDIMENTO DI CONCESSIONE)",
      (leftX + rightX) / 2, y, { align: "center" }
    );
    doc.setFont('PTSans', 'normal');

    // righe contenuto
    y += lineH;
    doc.text("Numero DRS:", leftX + pad, y);
    doc.text(drsNum || "-", leftX + pad + 60, y);

    y += lineH;
    doc.text("Data DRS:", leftX + pad, y);
    doc.text(drsDataISO ? getFormattedDate(drsDataISO) : "-", leftX + pad + 60, y);

    y += lineH;
    doc.text("Contributo concesso con DRS (€):", leftX + pad, y);
    doc.text(Number.isFinite(drsImporto) ? fmt2(drsImporto) : "-", leftX + pad + 90, y);

    // aggiorna il cursore verticale per ciò che viene dopo (nota *)
    currentY += blockH;
  })();

  // --- Nota (*) sotto la tabella ---
  const nota = `(*) Si ricorda che, in forza di quanto previsto dall'art.2 del DDG n.10111/2024 e ss.mm.ii.,
    ai fini del riconoscimento del contributo ammesso, i beneficiari, ad eccezione degli enti pubblici, dovranno
    rendicontare a saldo, come costo dell’intervento, un importo di spesa (inteso come importo ivato) pari ad
    almeno 1,25 volte la quota di finanziamento assegnato nel rispetto delle categorie di investimento indicate
    in domanda e in perizia e fatta salva la possibilità di ridurre/eliminare/modificare parte degli interventi
    purchè il progetto, nel suo complesso, rimanga sempre funzionale, funzionante, conforme alle direttive
    tecniche previste dal bando e corredato di tutti i pareri e i titoli abilitativi necessari per la
    realizzazione degli interventi.
    Si precisa inoltre che gli investimenti previsti nella tabella dovranno essere confermati/validati
    dal funzionario istruttore responsabile del procedimento amministrativo.`;

  // Stile della nota
  doc.setFont('PTSans', 'italic');
  doc.setFontSize(10);

  // Calcoliamo quante righe occuperà la nota
  const notaLines = doc.splitTextToSize(nota, 180);
  const lineH = 6; // altezza media riga
  const blockH = notaLines.length * lineH + 4;

  // Se la nota non ci sta nella stessa pagina → nuova pagina
  if (currentY + 10 + blockH > doc.internal.pageSize.height - 20) {
    doc.addPage();
    currentY = 20;
  }

  // Ora stampiamo la nota
  doc.text(notaLines, 13, currentY + 10);
  currentY += blockH + 10;

  // Se abbiamo scritto in prima pagina, metti il footer della prima
  doc.setFont('PTSans', 'italic');

  /* ------------------------------------------
   * SECONDA PAGINA – LIQUIDAZIONE INVESTIMENTI
   * ------------------------------------------ */
  //  doc.addPage();
  //currentY = 20; sumY = 7; x = 13;
  /*
    doc.setFont('PTSans', 'bold');
    doc.text("SEZIONE LIQUIDAZIONE INVESTIMENTI", 104, (currentY += sumY), 'center', '');
    doc.setFont('PTSans', 'normal');*/


  /* ------------------------------------------
   * TERZA PAGINA – CANTIERABILITÀ
   * ------------------------------------------ */
  doc.addPage();
  currentY = 20; sumY = 7; x = 13;

  doc.setFont('PTSans', 'bold');
  doc.setFontSize('12');
  doc.text("SEZIONE CANTIERABILITA’", 104, (currentY += sumY), 'center', '');
  doc.text("DICHIARA", 104, (currentY += sumY), 'center', '');
  doc.setFont('PTSans', 'normal');

  doc.text("- che il progetto previsto in fase di realizzazione definitiva (di cui alla Tab)", x, (currentY += sumY));

  const acquisizione_pareri = $('input[name="acquisizione-pareri"]:checked').val();

  if (acquisizione_pareri == 'no-necessita') {
    doc.text("è immediatamente cantierabile perchè non necessita acquisizione di pareri, autorizzazioni o nulla", x, (currentY += sumY));
    doc.text("osta o altri titoli abilitativi.", x, (currentY += sumY));
  } else if (acquisizione_pareri == 'necessita') {
    doc.text("è immediatamente cantierabile in quanto i titoli abilitativi necessari per la realizzazione degli interventi", x, (currentY += sumY));
    doc.text("(pareri, autorizzazioni, nulla osta, ecc.) qui di seguito elencati, sono stati già rilasciati dagli enti preposti.", x, (currentY += sumY));

    const enti_preposti = $("input[id^=enti_preposti_input]");
    enti_preposti.each(function () {
      const valore = $(this).val();
      if (valore && valore.length) {
        doc.setFont('PTSans', 'normal');
        doc.text("Titolo Abilitativo:  " + valore, x, (currentY += sumY));
      }
    });
  } else {
    doc.text("NON ERA immediatamente cantierabile ... alla data attuale, detti titoli", x, (currentY += sumY));
    doc.text("risultano integralmente rilasciati, rendendo di fatto l’intervento cantierabile.", x, (currentY += sumY));
  }

  doc.setFont('PTSans', 'italic');


  /* ------------------------------------------
   * QUARTA PAGINA – ALLEGATI
   * ------------------------------------------ */
  doc.addPage();
  currentY = 20; sumY = 7; x = 13;

  doc.setFont('PTSans', 'bold');
  doc.setFontSize('12');
  doc.text("Documentazione allegata alla domanda di pagamento del saldo finale", 104, (currentY += sumY), 'center', '');
  doc.setFont('PTSans', 'normal');

  if (acquisizione_pareri == 'necessita') {
    doc.text("- Si allega alla presente copia dei titoli abilitativi.", x, (currentY += sumY));
  }

  // Elenco dinamico allegati
  const allegati = (window.allegatiSelezionati || []);
  if (allegati.length > 0) {
    doc.text("Allegati caricati:", x, (currentY += sumY));
    allegati.forEach(a => {
      const riga = `• ${a.label}: ${a.nomeFile}`;
      const righe = doc.splitTextToSize(riga, 180);
      doc.text(righe, x, (currentY += sumY));
      currentY += (righe.length - 1) * sumY;
    });
  } else {
    doc.text("• Nessun allegato caricato nei campi previsti.", x, (currentY += sumY));
  }

  doc.setFont('PTSans', 'bold');
  doc.text("Dichiaro di aver letto e compreso la Privacy Policy", 18, (currentY += sumY));
  doc.setFont('PTSans', 'bold');
  footer();

  doc.setFont('PTSans', 'italic');

  /* ------------------------------------------
   * OUTPUT
   * ------------------------------------------ */
  drawFooterAllPages();

  return doc.output("blob");
}

/* ======== (Opzionale) Excel legacy ======== */
function crea_excel(codice) {
  // Mantieni la tua implementazione legacy se vuoi download a parte
  //riempi(codice);
}

/* ======== UI: registro IVA visibilità per Comuni ======== */
$(document).ready(function () {
  toggleRegistroIva();
  $("input[name='tipo_beneficiario']").on("change", function () {
    toggleRegistroIva();
  });

  function toggleRegistroIva() {
    const tipoBeneficiario = $("input[name='tipo_beneficiario']:checked").val();
    if (tipoBeneficiario === "comuni") {
      $("#campo_libro_registro_iva").hide();
      $("#registro_iva").val("");
    } else {
      $("#campo_libro_registro_iva").show();
    }
  }
});

/* ======== Dati bancari / tecnico: ricontrollo + badge ======== */
/*==== FUNZIONE CHECK DATI BANCARI ====*/

function check_sezione_dati_bancari() {
  var errori_dati_bancari = 0;

  var iban = $("#iban").val().toUpperCase();
  $("#iban").val(iban);
  if (iban.length === 0) {
    $("#iban").addClass("is-invalid");
    $("#errore_iban").addClass("invalid-feedback").text("IBAN obbligatorio.");
    errori_dati_bancari++;
  }
  else if (!reg_iban.test(iban)) {
    $("#iban").addClass("is-invalid");
    $("#errore_iban").addClass("invalid-feedback").text("IBAN non valido.");
    errori_dati_bancari++;
  }
  else {
    $("#iban").removeClass("is-invalid");
    $("#errore_iban").removeClass("invalid-feedback").text("");
  }

  var istitutoCredito = $("#istituto-credito").val().trim();
  if (istitutoCredito.length === 0) {
    $("#istituto-credito").addClass("is-invalid");
    $("#errore_istituto_credito").addClass("invalid-feedback").text("Istituto di credito obbligatorio.");
    errori_dati_bancari++;
  } else {
    $("#istituto-credito").removeClass("is-invalid");
    $("#errore_istituto_credito").removeClass("invalid-feedback").text("");
  }

  var agenzia_banca = $("#agenzia_banca").val().trim();
  if (agenzia_banca.length === 0) {
    $("#agenzia_banca").addClass("is-invalid");
    $("#errore_agenzia_banca").addClass("invalid-feedback").text("Agenzia obbligatoria.");
    errori_dati_bancari++;
  } else {
    $("#agenzia_banca").removeClass("is-invalid");
    $("#errore_agenzia_banca").removeClass("invalid-feedback").text("");
  }

  // Messaggio e badge validazione
  var $badge = $("#validazione_sezione_dati_bancari");
  var $btn = $("#dati-bancari .accordion-header button");
  $badge.removeClass("badge text-bg-success text-bg-error");
  $btn.removeClass("background-color-success-accordion background-color-error-accordion");

  if (errori_dati_bancari === 0) {
    $badge.addClass("badge text-bg-success").text("Sezione Compilata Correttamente");
    $btn.addClass("background-color-success-accordion");
  } else {
    var testoErrore = `Vi ${errori_dati_bancari === 1 ? "è" : "sono"} ${errori_dati_bancari} ${errori_dati_bancari === 1 ? "errore" : "errori"}`;
    $badge.addClass("badge text-bg-error").text(testoErrore);
    $btn.addClass("background-color-error-accordion");
  }

  return errori_dati_bancari;
}

/*==== FINE VALIDAZIONI SEZIONE DATI BANCARI ====*/

// ---- helper minimi (mettili una volta sola nel file) ----
function setErr(inputSel, msgSel, msg) {
  $(inputSel).addClass("is-invalid");
  $(msgSel).addClass("invalid-feedback").text(msg);
}
function clrErr(inputSel, msgSel) {
  $(inputSel).removeClass("is-invalid");
  $(msgSel).removeClass("invalid-feedback").text("");
}
function ordineFacoltativi() {
  const isComuni = $("input[name='tipo_beneficiario']:checked").val() === "comuni";
  const isInterno = $("input[name='tipo_tecnico']:checked").val() === "Tecnico Interno";
  return isComuni || isInterno; // se Comuni o Tecnico Interno, i 3 campi Ordine/Albo NON sono obbligatori
}


function check_sezione_tecnico() {
  let err = 0;

  const nome = $("#nome-tecnico").val().trim();
  const cognome = $("#cognome-tecnico").val().trim();
  const tel = $("#recapito-tecnico").val().trim();
  const pec = $("#pec-tecnico").val().trim();
  const mail = $("#mail-tecnico").val().trim();
  const isInterno = $("input[name='tipo_tecnico']:checked").val() === "Tecnico Interno";

  // Nome
  if (!nome || nome.length < 2 || !reg_nome_cognome.test(nome)) {
    setErr("#nome-tecnico", "#errore_nome_tecnico", "Nome del tecnico incaricato obbligatorio o non valido.");
    err++;
  } else clrErr("#nome-tecnico", "#errore_nome_tecnico");

  // Cognome
  if (!cognome || cognome.length < 2 || !reg_nome_cognome.test(cognome)) {
    setErr("#cognome-tecnico", "#errore_cognome_tecnico", "Cognome del tecnico incaricato obbligatorio o non valido.");
    err++;
  } else clrErr("#cognome-tecnico", "#errore_cognome_tecnico");

  // Telefono
  if (!tel) {
    setErr("#recapito-tecnico", "#errore_recapito_tecnico", "Recapito tecnico obbligatorio.");
    err++;
  } else if (!/^\+?\d+$/.test(tel)) {
    setErr("#recapito-tecnico", "#errore_recapito_tecnico", "Inserire solo numeri.");
    err++;
  } else clrErr("#recapito-tecnico", "#errore_recapito_tecnico");

  // PEC
  if (!pec || !valida_mail(pec)) {
    setErr("#pec-tecnico", "#errore_pec_tecnico", "Formato PEC errato.");
    err++;
  } else clrErr("#pec-tecnico", "#errore_pec_tecnico");

  // Mail
  if (!mail || !valida_mail(mail)) {
    setErr("#mail-tecnico", "#errore_mail_tecnico", "Formato mail errato.");
    err++;
  } else clrErr("#mail-tecnico", "#errore_mail_tecnico");

  // Dati indirizzo (solo Tecnico ESTERNO)
  if (!isInterno) {
    const com = $("#comune-studio-professionale").val().trim();
    const prov = $("#provincia-studio-professionale").val().trim();
    const ind = $("#indirizzo-studio-professionale").val().trim();
    const civ = $("#civico-studio-professionale").val().trim();

    if (!com || !reg_luogo_nascita_residenza.test(com)) {
      setErr("#comune-studio-professionale", "#errore_comune_studio_professionale", "Comune studio professionale obbligatorio.");
      err++;
    } else clrErr("#comune-studio-professionale", "#errore_comune_studio_professionale");

    if (!prov || !reg_luogo_nascita_residenza.test(prov)) {
      setErr("#provincia-studio-professionale", "#errore_provincia_studio_professionale", "Provincia studio professionale obbligatoria.");
      err++;
    } else clrErr("#provincia-studio-professionale", "#errore_provincia_studio_professionale");

    if (!ind || !reg_indirizzo.test(ind)) {
      setErr("#indirizzo-studio-professionale", "#errore_indirizzo_studio_professionale", "Indirizzo studio professionale obbligatorio.");
      err++;
    } else clrErr("#indirizzo-studio-professionale", "#errore_indirizzo_studio_professionale");

    if (!civ) {
      setErr("#civico-studio-professionale", "#errore_civico_studio_professionale", "Numero civico obbligatorio.");
      err++;
    } else clrErr("#civico-studio-professionale", "#errore_civico_studio_professionale");
  } else {
    // pulizia se Interno
    clrErr("#comune-studio-professionale", "#errore_comune_studio_professionale");
    clrErr("#provincia-studio-professionale", "#errore_provincia_studio_professionale");
    clrErr("#indirizzo-studio-professionale", "#errore_indirizzo_studio_professionale");
    clrErr("#civico-studio-professionale", "#errore_civico_studio_professionale");
    // tipologia incarico richiesta per Interno
    const incarico = $("#tipologia_incarico").val().trim();
    if (!incarico || incarico.length < 2 || !reg_nome_cognome.test(incarico)) {
      setErr("#tipologia_incarico", "#errore_tipologia_incarico", "Tipologia incarico/ruolo obbligatoria o non valida.");
      err++;
    } else clrErr("#tipologia_incarico", "#errore_tipologia_incarico");
  }

  // I 3 campi Ordine/Albo: obbligatori solo se NON ordineFacoltativi()
  if (!ordineFacoltativi()) {
    const provOrd = $("#provincia-ordine-tecnico").val().trim();
    const ordine = $("#ordine-tecnico").val().trim();
    const num = $("#numero-iscrizione-ordine-tecnico").val().trim();

    if (!provOrd || !reg_luogo_nascita_residenza.test(provOrd)) {
      setErr("#provincia-ordine-tecnico", "#errore_provincia_ordine_tecnico", "Provincia/Sezione/Regione di iscrizione obbligatoria.");
      err++;
    } else clrErr("#provincia-ordine-tecnico", "#errore_provincia_ordine_tecnico");

    if (!ordine || !reg_nome_cognome.test(ordine)) {
      setErr("#ordine-tecnico", "#errore_ordine_tecnico", "Ordine/Albo di iscrizione obbligatorio.");
      err++;
    } else clrErr("#ordine-tecnico", "#errore_ordine_tecnico");

    if (!num) {
      setErr("#numero-iscrizione-ordine-tecnico", "#errore_numero_iscrizione_ordine_tecnico", "Numero di iscrizione obbligatorio.");
      err++;
    } else clrErr("#numero-iscrizione-ordine-tecnico", "#errore_numero_iscrizione_ordine_tecnico");
  } else {
    clrErr("#provincia-ordine-tecnico", "#errore_provincia_ordine_tecnico");
    clrErr("#ordine-tecnico", "#errore_ordine_tecnico");
    clrErr("#numero-iscrizione-ordine-tecnico", "#errore_numero_iscrizione_ordine_tecnico");
  }

  // Badge/colore sezione
  const $badge = $("#validazione_sezione_tecnico_competente");
  const $btn = $("#tecnico-competente .accordion-header button");
  $badge.removeClass("badge text-bg-success text-bg-error").text("");
  $btn.removeClass("background-color-success-accordion background-color-error-accordion");

  if (err === 0) {
    $badge.addClass("badge text-bg-success").text("Sezione Compilata Correttamente");
    $btn.addClass("background-color-success-accordion");
  } else {
    $badge.addClass("badge text-bg-error").text(`Vi ${err === 1 ? "è" : "sono"} ${err} ${err === 1 ? "errore" : "errori"}`);
    $btn.addClass("background-color-error-accordion");
    // apri la sezione e scrolla al primo errore
    const $acc = $("#collapseFour");
    if (!$acc.hasClass("show")) document.querySelector('button[aria-controls="collapseFour"]').click();
    const $first = $("#tecnico-competente .is-invalid").first();
    if ($first.length) $first[0].scrollIntoView({ behavior: "smooth", block: "center" });
  }

  return err; // 0 = ok, >0 = errori
}


$(document).on("change", "input[type=file]", function () {
  const MAX_BYTES = 5 * 1024 * 1024; // 5 MB
  const $input = $(this);
  const files = this.files;
  if (!files || files.length === 0) {
    return; // nessun file selezionato, ok
  }
  const f = files[0];
  if (f.size > MAX_BYTES) {
    // File troppo grande
    $input.addClass("is-invalid");
    // Mostra messaggio d’errore vicino all’input
    const $err = $input.next(".invalid-feedback");
    if ($err.length === 0) {
      // se non esiste, crealo
      $input.after(`<div class="invalid-feedback d-block">Il file "${f.name}" supera 5 MB: riduci la dimensione.</div>`);
    } else {
      $err.addClass("d-block").text(`Il file "${f.name}" supera 5 MB: riduci la dimensione.`);
    }
  } else {
    // File ok
    $input.removeClass("is-invalid");
    $input.next(".invalid-feedback").removeClass("d-block").text("");
  }
});






